/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDialect
implements JdbcDialect {
    private static final Logger log = LoggerFactory.getLogger(OracleDialect.class);
    private static final int DEFAULT_ORACLE_FETCH_SIZE = 128;
    public String fieldIde = FieldIdeEnum.ORIGINAL.getValue();
    private final boolean handleBlobAsString;

    public OracleDialect(String fieldIde) {
        this(fieldIde, (Boolean)JdbcOptions.HANDLE_BLOB_AS_STRING.defaultValue());
    }

    public OracleDialect() {
        this(FieldIdeEnum.ORIGINAL.getValue(), (Boolean)JdbcOptions.HANDLE_BLOB_AS_STRING.defaultValue());
    }

    public OracleDialect(String fieldIde, boolean handleBlobAsString) {
        this.fieldIde = fieldIde;
        this.handleBlobAsString = handleBlobAsString;
    }

    @Override
    public String dialectName() {
        return "Oracle";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new OracleJdbcRowConverter();
    }

    @Override
    public TypeConverter<BasicTypeDefine> getTypeConverter() {
        return new OracleTypeConverter(true, this.handleBlobAsString);
    }

    @Override
    public String hashModForField(String fieldName, int mod) {
        return "MOD(ORA_HASH(" + this.quoteIdentifier(fieldName) + ")," + mod + ")";
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new OracleTypeMapper(true, this.handleBlobAsString);
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("\"").append(parts[i]).append("\"").append(".");
            }
            return sb.append("\"").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("\"").toString();
        }
        return "\"" + this.getFieldIde(identifier, this.fieldIde) + "\"";
    }

    @Override
    public String tableIdentifier(String database, String tableName) {
        return this.quoteIdentifier(tableName);
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).collect(Collectors.toList());
        String valuesBinding = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName + " " + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s FROM DUAL", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(fieldName -> String.format("TARGET.%s=SOURCE.%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(fieldName -> "SOURCE." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String upsertSQL = String.format(" MERGE INTO %s TARGET USING (%s) SOURCE ON (%s)  WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s)", this.tableIdentifier(database, tableName), usingClause, onConditions, updateSetClause, insertFields, insertValues);
        return Optional.of(upsertSQL);
    }

    @Override
    public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        if (fetchSize > 0) {
            statement.setFetchSize(fetchSize);
        } else {
            statement.setFetchSize(128);
        }
        return statement;
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return this.quoteIdentifier(tablePath.getSchemaAndTableName());
    }

    /*
     * Exception decompiling
     */
    @Override
    public Long approximateRowCntStatement(Connection connection, JdbcSourceTable table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object queryNextChunkMax(Connection connection, JdbcSourceTable table, String columnName, int chunkSize, Object includedLowerBound) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object[] sampleDataFromColumn(Connection connection, JdbcSourceTable table, String columnName, int samplingRate, int fetchSize) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableAddColumnEvent event) throws SQLException {
        ArrayList<String> ddlSQL = new ArrayList<String>();
        ddlSQL.add(this.buildUpdateColumnSQL(connection, tablePath, (AlterTableColumnEvent)event));
        if (event.getColumn().getComment() != null) {
            ddlSQL.add(this.buildUpdateColumnCommentSQL(tablePath, event.getColumn()));
        }
        try (Statement statement = connection.createStatement();){
            for (String sql : ddlSQL) {
                log.info("Executing add column SQL: {}", (Object)sql);
                statement.execute(sql);
            }
        }
    }

    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableChangeColumnEvent event) throws SQLException {
        ArrayList<String> ddlSQL = new ArrayList<String>();
        if (event.getOldColumn() != null && !event.getColumn().getName().equals(event.getOldColumn())) {
            StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE ").append(this.tableIdentifier(tablePath)).append(" RENAME COLUMN ").append(this.quoteIdentifier(event.getOldColumn())).append(" TO ").append(this.quoteIdentifier(event.getColumn().getName()));
            ddlSQL.add(sqlBuilder.toString());
        }
        try (Statement statement = connection.createStatement();){
            for (String sql : ddlSQL) {
                log.info("Executing change column SQL: {}", (Object)sql);
                statement.execute(sql);
            }
        }
        if (event.getColumn().getDataType() != null) {
            this.applySchemaChange(connection, tablePath, AlterTableModifyColumnEvent.modify((TableIdentifier)event.tableIdentifier(), (Column)event.getColumn()));
        }
    }

    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableModifyColumnEvent event) throws SQLException {
        ArrayList<String> ddlSQL = new ArrayList<String>();
        ddlSQL.add(this.buildUpdateColumnSQL(connection, tablePath, (AlterTableColumnEvent)event));
        if (event.getColumn().getComment() != null) {
            ddlSQL.add(this.buildUpdateColumnCommentSQL(tablePath, event.getColumn()));
        }
        try (Statement statement = connection.createStatement();){
            for (String sql : ddlSQL) {
                log.info("Executing modify column SQL: {}", (Object)sql);
                statement.execute(sql);
            }
        }
    }

    private String buildUpdateColumnSQL(Connection connection, TablePath tablePath, AlterTableColumnEvent event) throws SQLException {
        Column column;
        String actionType;
        if (event instanceof AlterTableModifyColumnEvent) {
            actionType = "MODIFY";
            column = ((AlterTableModifyColumnEvent)event).getColumn();
        } else if (event instanceof AlterTableAddColumnEvent) {
            actionType = "ADD";
            column = ((AlterTableAddColumnEvent)event).getColumn();
        } else {
            throw new IllegalArgumentException("Unsupported AlterTableColumnEvent: " + event);
        }
        String sourceDialectName = event.getSourceDialectName();
        boolean sameCatalog = StringUtils.equals(this.dialectName(), sourceDialectName);
        BasicTypeDefine typeDefine = (BasicTypeDefine)this.getTypeConverter().reconvert(column);
        String columnType = sameCatalog ? column.getSourceType() : typeDefine.getColumnType();
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE  ").append(this.tableIdentifier(tablePath)).append(" ").append(actionType).append(" ").append(this.quoteIdentifier(column.getName())).append(" ").append(columnType);
        if (column.getDefaultValue() != null && sameCatalog) {
            sqlBuilder.append(" ").append(this.sqlClauseWithDefaultValue(typeDefine, sourceDialectName));
        }
        if (event instanceof AlterTableModifyColumnEvent) {
            boolean targetColumnNullable = this.columnIsNullable(connection, tablePath, column.getName());
            if (column.isNullable() != targetColumnNullable) {
                sqlBuilder.append(" ").append(column.isNullable() ? "NULL" : "NOT NULL");
            }
        } else {
            sqlBuilder.append(" ").append(column.isNullable() ? "NULL" : "NOT NULL");
        }
        return sqlBuilder.toString();
    }

    private String buildUpdateColumnCommentSQL(TablePath tablePath, Column column) {
        return String.format("COMMENT ON COLUMN %s.%s IS '%s'", this.tableIdentifier(tablePath), this.quoteIdentifier(column.getName()), column.getComment());
    }

    private boolean columnIsNullable(Connection connection, TablePath tablePath, String column) throws SQLException {
        String selectColumnSQL = "SELECT        NULLABLE FROM        ALL_TAB_COLUMNS c        WHERE c.owner = '" + tablePath.getSchemaName() + "'        AND c.table_name = '" + tablePath.getTableName() + "'        AND c.column_name = '" + column + "'";
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery(selectColumnSQL);
            rs.next();
            boolean bl = rs.getString("NULLABLE").equals("Y");
            return bl;
        }
    }

    @Override
    public String dualTable() {
        return " FROM dual ";
    }

    @Override
    public String getCollateSql(String collate) {
        if (StringUtils.isNotBlank(collate)) {
            StringBuilder sql = new StringBuilder();
            sql.append("NLSSORT(").append("char_val").append(", 'NLS_SORT=").append(collate).append("')");
            return sql.toString();
        }
        return "char_val";
    }
}

