/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.cdc;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.cdc.CDCConfig;
import org.tikv.cdc.CDCEvent;
import org.tikv.common.region.TiRegion;
import org.tikv.common.util.FastByteComparisons;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.kvproto.Cdcpb;
import org.tikv.kvproto.ChangeDataGrpc;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.common.base.Preconditions;
import org.tikv.shade.com.google.common.collect.ImmutableSet;
import org.tikv.shade.io.grpc.ManagedChannel;
import org.tikv.shade.io.grpc.stub.StreamObserver;

class RegionCDCClient
implements AutoCloseable,
StreamObserver<Cdcpb.ChangeDataEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionCDCClient.class);
    private static final AtomicLong REQ_ID_COUNTER = new AtomicLong(0L);
    private static final Set<Cdcpb.Event.LogType> ALLOWED_LOGTYPE = ImmutableSet.of(Cdcpb.Event.LogType.PREWRITE, Cdcpb.Event.LogType.COMMIT, Cdcpb.Event.LogType.COMMITTED, Cdcpb.Event.LogType.ROLLBACK);
    private final TiRegion region;
    private final Coprocessor.KeyRange keyRange;
    private final Coprocessor.KeyRange regionKeyRange;
    private final ManagedChannel channel;
    private final ChangeDataGrpc.ChangeDataStub asyncStub;
    private final Consumer<CDCEvent> eventConsumer;
    private final CDCConfig config;
    private final Predicate<Cdcpb.Event.Row> rowFilter;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final boolean started = false;

    public RegionCDCClient(TiRegion region, final Coprocessor.KeyRange keyRange, ManagedChannel channel, Consumer<CDCEvent> eventConsumer, final CDCConfig config) {
        this.region = region;
        this.keyRange = keyRange;
        this.channel = channel;
        this.asyncStub = ChangeDataGrpc.newStub(channel);
        this.eventConsumer = eventConsumer;
        this.config = config;
        this.regionKeyRange = Coprocessor.KeyRange.newBuilder().setStart(region.getStartKey()).setEnd(region.getEndKey()).build();
        this.rowFilter = this.regionEnclosed() ? row -> true : new Predicate<Cdcpb.Event.Row>(){
            final byte[] buffer;
            final byte[] start;
            final byte[] end;
            {
                this.buffer = new byte[config.getMaxRowKeySize()];
                this.start = keyRange.getStart().toByteArray();
                this.end = keyRange.getEnd().toByteArray();
            }

            @Override
            public boolean test(Cdcpb.Event.Row row) {
                int len = row.getKey().size();
                row.getKey().copyTo(this.buffer, 0);
                return FastByteComparisons.compareTo(this.buffer, 0, len, this.start, 0, this.start.length) >= 0 && FastByteComparisons.compareTo(this.buffer, 0, len, this.end, 0, this.end.length) < 0;
            }
        };
    }

    public synchronized void start(long startTs) {
        Preconditions.checkState(true, "RegionCDCClient has already started");
        this.running.set(true);
        LOGGER.info("start streaming region: {}, running: {}", (Object)this.region.getId(), (Object)this.running.get());
        Cdcpb.ChangeDataRequest request = Cdcpb.ChangeDataRequest.newBuilder().setRequestId(REQ_ID_COUNTER.incrementAndGet()).setHeader(Cdcpb.Header.newBuilder().setTicdcVersion("5.0.0").build()).setRegionId(this.region.getId()).setCheckpointTs(startTs).setStartKey(this.keyRange.getStart()).setEndKey(this.keyRange.getEnd()).setRegionEpoch(this.region.getRegionEpoch()).setExtraOp(this.config.getExtraOp()).build();
        StreamObserver<Cdcpb.ChangeDataRequest> requestObserver = this.asyncStub.eventFeed(this);
        requestObserver.onNext(request);
    }

    public TiRegion getRegion() {
        return this.region;
    }

    public Coprocessor.KeyRange getKeyRange() {
        return this.keyRange;
    }

    public Coprocessor.KeyRange getRegionKeyRange() {
        return this.regionKeyRange;
    }

    public boolean regionEnclosed() {
        return KeyRangeUtils.makeRange(this.keyRange.getStart(), this.keyRange.getEnd()).encloses(KeyRangeUtils.makeRange(this.regionKeyRange.getStart(), this.regionKeyRange.getEnd()));
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        LOGGER.info("close (region: {})", (Object)this.region.getId());
        this.running.set(false);
        RegionCDCClient regionCDCClient = this;
        synchronized (regionCDCClient) {
            this.channel.shutdown();
        }
        try {
            LOGGER.debug("awaitTermination (region: {})", (Object)this.region.getId());
            this.channel.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to shutdown channel(regionId: {})", (Object)this.region.getId());
            Thread.currentThread().interrupt();
            RegionCDCClient regionCDCClient2 = this;
            synchronized (regionCDCClient2) {
                this.channel.shutdownNow();
            }
        }
        LOGGER.info("terminated (region: {})", (Object)this.region.getId());
    }

    @Override
    public void onCompleted() {
        this.onError(new IllegalStateException("RegionCDCClient should never complete"));
    }

    @Override
    public void onError(Throwable error) {
        LOGGER.error("region CDC error: region: {}, error: {}", (Object)this.region.getId(), (Object)error);
        this.running.set(false);
        this.eventConsumer.accept(CDCEvent.error(this.region.getId(), error));
    }

    @Override
    public void onNext(Cdcpb.ChangeDataEvent event) {
        try {
            if (this.running.get()) {
                Cdcpb.ResolvedTs resolvedTs;
                event.getEventsList().stream().flatMap(ev -> ev.getEntries().getEntriesList().stream()).filter(row -> ALLOWED_LOGTYPE.contains(row.getType())).filter(this.rowFilter).map(row -> CDCEvent.rowEvent(this.region.getId(), row)).forEach(this::submitEvent);
                if (event.hasResolvedTs() && (resolvedTs = event.getResolvedTs()).getRegionsList().indexOf(this.region.getId()) >= 0) {
                    this.submitEvent(CDCEvent.resolvedTsEvent(this.region.getId(), resolvedTs.getTs()));
                }
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    private void submitEvent(CDCEvent event) {
        LOGGER.debug("submit event: {}", (Object)event);
        this.eventConsumer.accept(event);
    }
}

