/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.HostMapping;
import org.tikv.common.pd.PDUtils;
import org.tikv.shade.io.grpc.ManagedChannel;
import org.tikv.shade.io.grpc.netty.GrpcSslContexts;
import org.tikv.shade.io.grpc.netty.NettyChannelBuilder;
import org.tikv.shade.io.netty.handler.ssl.SslContext;
import org.tikv.shade.io.netty.handler.ssl.SslContextBuilder;

public class ChannelFactory
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFactory.class);
    private final int maxFrameSize;
    private final int keepaliveTime;
    private final int keepaliveTimeout;
    private final int idleTimeout;
    private final ConcurrentHashMap<String, ManagedChannel> connPool = new ConcurrentHashMap();
    private final SslContextBuilder sslContextBuilder;
    private static final String PUB_KEY_INFRA = "PKIX";

    public ChannelFactory(int maxFrameSize, int keepaliveTime, int keepaliveTimeout, int idleTimeout) {
        this.maxFrameSize = maxFrameSize;
        this.keepaliveTime = keepaliveTime;
        this.keepaliveTimeout = keepaliveTimeout;
        this.idleTimeout = idleTimeout;
        this.sslContextBuilder = null;
    }

    public ChannelFactory(int maxFrameSize, int keepaliveTime, int keepaliveTimeout, int idleTimeout, String trustCertCollectionFilePath, String keyCertChainFilePath, String keyFilePath) {
        this.maxFrameSize = maxFrameSize;
        this.keepaliveTime = keepaliveTime;
        this.keepaliveTimeout = keepaliveTimeout;
        this.idleTimeout = idleTimeout;
        this.sslContextBuilder = this.getSslContextBuilder(trustCertCollectionFilePath, keyCertChainFilePath, keyFilePath);
    }

    public ChannelFactory(int maxFrameSize, int keepaliveTime, int keepaliveTimeout, int idleTimeout, String jksKeyPath, String jksKeyPassword, String jkstrustPath, String jksTrustPassword) {
        this.maxFrameSize = maxFrameSize;
        this.keepaliveTime = keepaliveTime;
        this.keepaliveTimeout = keepaliveTimeout;
        this.idleTimeout = idleTimeout;
        this.sslContextBuilder = this.getSslContextBuilder(jksKeyPath, jksKeyPassword, jkstrustPath, jksTrustPassword);
    }

    private SslContextBuilder getSslContextBuilder(String jksKeyPath, String jksKeyPassword, String jksTrustPath, String jksTrustPassword) {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        try {
            if (jksKeyPath != null && jksKeyPassword != null) {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(new FileInputStream(jksKeyPath), jksKeyPassword.toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, jksKeyPassword.toCharArray());
                builder.keyManager(keyManagerFactory);
            }
            if (jksTrustPath != null && jksTrustPassword != null) {
                KeyStore trustStore = KeyStore.getInstance("JKS");
                trustStore.load(new FileInputStream(jksTrustPath), jksTrustPassword.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(PUB_KEY_INFRA);
                trustManagerFactory.init(trustStore);
                builder.trustManager(trustManagerFactory);
            }
        }
        catch (Exception e) {
            logger.error("JKS SSL context builder failed!", (Throwable)e);
        }
        return builder;
    }

    private SslContextBuilder getSslContextBuilder(String trustCertCollectionFilePath, String keyCertChainFilePath, String keyFilePath) {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        if (trustCertCollectionFilePath != null) {
            builder.trustManager(new File(trustCertCollectionFilePath));
        }
        if (keyCertChainFilePath != null && keyFilePath != null) {
            builder.keyManager(new File(keyCertChainFilePath), new File(keyFilePath));
        }
        return builder;
    }

    public ManagedChannel getChannel(String addressStr, HostMapping hostMapping) {
        return this.connPool.computeIfAbsent(addressStr, key -> {
            URI mappedAddr;
            URI address;
            try {
                address = PDUtils.addrToUri(key);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to form address " + key, e);
            }
            try {
                mappedAddr = hostMapping.getMappedURI(address);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to get mapped address " + address, e);
            }
            NettyChannelBuilder builder = (NettyChannelBuilder)NettyChannelBuilder.forAddress(mappedAddr.getHost(), mappedAddr.getPort()).maxInboundMessageSize(this.maxFrameSize).keepAliveTime(this.keepaliveTime, TimeUnit.SECONDS).keepAliveTimeout(this.keepaliveTimeout, TimeUnit.SECONDS).keepAliveWithoutCalls(true).idleTimeout(this.idleTimeout, TimeUnit.SECONDS);
            if (this.sslContextBuilder == null) {
                return builder.usePlaintext().build();
            }
            SslContext sslContext = null;
            try {
                sslContext = this.sslContextBuilder.build();
            }
            catch (SSLException e) {
                logger.error("create ssl context failed!", (Throwable)e);
                return null;
            }
            return builder.sslContext(sslContext).build();
        });
    }

    @Override
    public void close() {
        for (ManagedChannel ch : this.connPool.values()) {
            ch.shutdown();
        }
        this.connPool.clear();
    }
}

