/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.basic;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.kafka.common.utils.Scheduler;
import org.apache.kafka.common.utils.Shell;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.basic.BasicTopology;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.Topology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPlatform
implements Platform {
    private static final Logger log = LoggerFactory.getLogger(BasicPlatform.class);
    private final Node curNode;
    private final BasicTopology topology;
    private final Scheduler scheduler;
    private final CommandRunner commandRunner;

    public BasicPlatform(String curNodeName, BasicTopology topology, Scheduler scheduler, CommandRunner commandRunner) {
        this.curNode = topology.node(curNodeName);
        if (this.curNode == null) {
            throw new RuntimeException(String.format("No node named %s found in the cluster!  Cluster nodes are: %s", curNodeName, Utils.join(topology.nodes().keySet(), ",")));
        }
        this.topology = topology;
        this.scheduler = scheduler;
        this.commandRunner = commandRunner;
    }

    public BasicPlatform(String curNodeName, Scheduler scheduler, JsonNode configRoot) {
        JsonNode nodes = configRoot.get("nodes");
        if (nodes == null) {
            throw new RuntimeException("Expected to find a 'nodes' field in the root JSON configuration object");
        }
        this.topology = new BasicTopology(nodes);
        this.scheduler = scheduler;
        this.curNode = this.topology.node(curNodeName);
        if (this.curNode == null) {
            throw new RuntimeException(String.format("No node named %s found in the cluster!  Cluster nodes are: %s", curNodeName, Utils.join(this.topology.nodes().keySet(), ",")));
        }
        this.commandRunner = new ShellCommandRunner();
    }

    @Override
    public String name() {
        return "BasicPlatform";
    }

    @Override
    public Node curNode() {
        return this.curNode;
    }

    @Override
    public Topology topology() {
        return this.topology;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public String runCommand(String[] command) throws IOException {
        return this.commandRunner.run(this.curNode, command);
    }

    public static class ShellCommandRunner
    implements CommandRunner {
        @Override
        public String run(Node curNode, String[] command) throws IOException {
            try {
                String result = Shell.execCommand(command);
                log.info("RUN: {}. RESULT: [{}]", (Object)Utils.join(command, " "), (Object)result);
                return result;
            }
            catch (IOException | RuntimeException e) {
                log.info("RUN: {}. ERROR: [{}]", (Object)Utils.join(command, " "), (Object)e.getMessage());
                throw e;
            }
        }
    }

    public static interface CommandRunner {
        public String run(Node var1, String[] var2) throws IOException;
    }
}

