/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.config;

import io.debezium.config.Configuration;
import java.util.Properties;
import org.apache.seatunnel.connectors.cdc.base.config.SourceConfig;
import org.apache.seatunnel.connectors.cdc.base.config.StartupConfig;
import org.apache.seatunnel.connectors.cdc.base.config.StopConfig;

public abstract class BaseSourceConfig
implements SourceConfig {
    private static final long serialVersionUID = 1L;
    protected final StartupConfig startupConfig;
    protected final StopConfig stopConfig;
    protected final int splitSize;
    protected final double distributionFactorUpper;
    protected final double distributionFactorLower;
    protected final int sampleShardingThreshold;
    protected final int inverseSamplingRate;
    protected final Properties dbzProperties;

    public BaseSourceConfig(StartupConfig startupConfig, StopConfig stopConfig, int splitSize, double distributionFactorUpper, double distributionFactorLower, int sampleShardingThreshold, int inverseSamplingRate, Properties dbzProperties) {
        this.startupConfig = startupConfig;
        this.stopConfig = stopConfig;
        this.splitSize = splitSize;
        this.distributionFactorUpper = distributionFactorUpper;
        this.distributionFactorLower = distributionFactorLower;
        this.sampleShardingThreshold = sampleShardingThreshold;
        this.inverseSamplingRate = inverseSamplingRate;
        this.dbzProperties = dbzProperties;
    }

    public Configuration getDbzConfiguration() {
        return Configuration.from(this.dbzProperties);
    }

    @Override
    public StartupConfig getStartupConfig() {
        return this.startupConfig;
    }

    @Override
    public StopConfig getStopConfig() {
        return this.stopConfig;
    }

    @Override
    public int getSplitSize() {
        return this.splitSize;
    }

    public double getDistributionFactorUpper() {
        return this.distributionFactorUpper;
    }

    public double getDistributionFactorLower() {
        return this.distributionFactorLower;
    }

    public int getSampleShardingThreshold() {
        return this.sampleShardingThreshold;
    }

    public int getInverseSamplingRate() {
        return this.inverseSamplingRate;
    }
}

