/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;

public class JdbcSinkConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    private JdbcConnectionConfig jdbcConnectionConfig;
    private boolean isExactlyOnce;
    private String simpleSql;
    private String database;
    private String table;
    private List<String> primaryKeys;
    private boolean supportUpsertByQueryPrimaryKeyExist;

    public static JdbcSinkConfig of(ReadonlyConfig config) {
        Builder builder = JdbcSinkConfig.builder();
        builder.jdbcConnectionConfig(JdbcConnectionConfig.of(config));
        builder.isExactlyOnce((Boolean)config.get(JdbcOptions.IS_EXACTLY_ONCE));
        config.getOptional(JdbcOptions.PRIMARY_KEYS).ifPresent(builder::primaryKeys);
        config.getOptional(JdbcOptions.DATABASE).ifPresent(builder::database);
        config.getOptional(JdbcOptions.TABLE).ifPresent(builder::table);
        config.getOptional(JdbcOptions.SUPPORT_UPSERT_BY_QUERY_PRIMARY_KEY_EXIST).ifPresent(builder::supportUpsertByQueryPrimaryKeyExist);
        config.getOptional(JdbcOptions.QUERY).ifPresent(builder::simpleSql);
        return builder.build();
    }

    JdbcSinkConfig(JdbcConnectionConfig jdbcConnectionConfig, boolean isExactlyOnce, String simpleSql, String database, String table, List<String> primaryKeys, boolean supportUpsertByQueryPrimaryKeyExist) {
        this.jdbcConnectionConfig = jdbcConnectionConfig;
        this.isExactlyOnce = isExactlyOnce;
        this.simpleSql = simpleSql;
        this.database = database;
        this.table = table;
        this.primaryKeys = primaryKeys;
        this.supportUpsertByQueryPrimaryKeyExist = supportUpsertByQueryPrimaryKeyExist;
    }

    public static Builder builder() {
        return new Builder();
    }

    public JdbcConnectionConfig getJdbcConnectionConfig() {
        return this.jdbcConnectionConfig;
    }

    public boolean isExactlyOnce() {
        return this.isExactlyOnce;
    }

    public String getSimpleSql() {
        return this.simpleSql;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public boolean isSupportUpsertByQueryPrimaryKeyExist() {
        return this.supportUpsertByQueryPrimaryKeyExist;
    }

    public void setJdbcConnectionConfig(JdbcConnectionConfig jdbcConnectionConfig) {
        this.jdbcConnectionConfig = jdbcConnectionConfig;
    }

    public void setExactlyOnce(boolean isExactlyOnce) {
        this.isExactlyOnce = isExactlyOnce;
    }

    public void setSimpleSql(String simpleSql) {
        this.simpleSql = simpleSql;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void setSupportUpsertByQueryPrimaryKeyExist(boolean supportUpsertByQueryPrimaryKeyExist) {
        this.supportUpsertByQueryPrimaryKeyExist = supportUpsertByQueryPrimaryKeyExist;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSinkConfig)) {
            return false;
        }
        JdbcSinkConfig other = (JdbcSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExactlyOnce() != other.isExactlyOnce()) {
            return false;
        }
        if (this.isSupportUpsertByQueryPrimaryKeyExist() != other.isSupportUpsertByQueryPrimaryKeyExist()) {
            return false;
        }
        JdbcConnectionConfig this$jdbcConnectionConfig = this.getJdbcConnectionConfig();
        JdbcConnectionConfig other$jdbcConnectionConfig = other.getJdbcConnectionConfig();
        if (this$jdbcConnectionConfig == null ? other$jdbcConnectionConfig != null : !this$jdbcConnectionConfig.equals(other$jdbcConnectionConfig)) {
            return false;
        }
        String this$simpleSql = this.getSimpleSql();
        String other$simpleSql = other.getSimpleSql();
        if (this$simpleSql == null ? other$simpleSql != null : !this$simpleSql.equals(other$simpleSql)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        List<String> this$primaryKeys = this.getPrimaryKeys();
        List<String> other$primaryKeys = other.getPrimaryKeys();
        return !(this$primaryKeys == null ? other$primaryKeys != null : !((Object)this$primaryKeys).equals(other$primaryKeys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExactlyOnce() ? 79 : 97);
        result = result * 59 + (this.isSupportUpsertByQueryPrimaryKeyExist() ? 79 : 97);
        JdbcConnectionConfig $jdbcConnectionConfig = this.getJdbcConnectionConfig();
        result = result * 59 + ($jdbcConnectionConfig == null ? 43 : $jdbcConnectionConfig.hashCode());
        String $simpleSql = this.getSimpleSql();
        result = result * 59 + ($simpleSql == null ? 43 : $simpleSql.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        List<String> $primaryKeys = this.getPrimaryKeys();
        result = result * 59 + ($primaryKeys == null ? 43 : ((Object)$primaryKeys).hashCode());
        return result;
    }

    public String toString() {
        return "JdbcSinkConfig(jdbcConnectionConfig=" + this.getJdbcConnectionConfig() + ", isExactlyOnce=" + this.isExactlyOnce() + ", simpleSql=" + this.getSimpleSql() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", primaryKeys=" + this.getPrimaryKeys() + ", supportUpsertByQueryPrimaryKeyExist=" + this.isSupportUpsertByQueryPrimaryKeyExist() + ")";
    }

    public static class Builder {
        private JdbcConnectionConfig jdbcConnectionConfig;
        private boolean isExactlyOnce;
        private String simpleSql;
        private String database;
        private String table;
        private List<String> primaryKeys;
        private boolean supportUpsertByQueryPrimaryKeyExist;

        Builder() {
        }

        public Builder jdbcConnectionConfig(JdbcConnectionConfig jdbcConnectionConfig) {
            this.jdbcConnectionConfig = jdbcConnectionConfig;
            return this;
        }

        public Builder isExactlyOnce(boolean isExactlyOnce) {
            this.isExactlyOnce = isExactlyOnce;
            return this;
        }

        public Builder simpleSql(String simpleSql) {
            this.simpleSql = simpleSql;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public Builder supportUpsertByQueryPrimaryKeyExist(boolean supportUpsertByQueryPrimaryKeyExist) {
            this.supportUpsertByQueryPrimaryKeyExist = supportUpsertByQueryPrimaryKeyExist;
            return this;
        }

        public JdbcSinkConfig build() {
            return new JdbcSinkConfig(this.jdbcConnectionConfig, this.isExactlyOnce, this.simpleSql, this.database, this.table, this.primaryKeys, this.supportUpsertByQueryPrimaryKeyExist);
        }

        public String toString() {
            return "JdbcSinkConfig.Builder(jdbcConnectionConfig=" + this.jdbcConnectionConfig + ", isExactlyOnce=" + this.isExactlyOnce + ", simpleSql=" + this.simpleSql + ", database=" + this.database + ", table=" + this.table + ", primaryKeys=" + this.primaryKeys + ", supportUpsertByQueryPrimaryKeyExist=" + this.supportUpsertByQueryPrimaryKeyExist + ")";
        }
    }
}

