/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.utils;

import io.debezium.relational.Column;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public class SqlServerTypeUtils {
    private static final String SQLSERVER_CHAR = "CHAR";
    private static final String SQLSERVER_VARCHAR = "VARCHAR";
    private static final String SQLSERVER_NCHAR = "NCHAR";
    private static final String SQLSERVER_NVARCHAR = "NVARCHAR";
    private static final String SQLSERVER_STRUCT = "STRUCT";
    private static final String SQLSERVER_CLOB = "CLOB";
    private static final String SQLSERVER_LONGVARCHAR = "LONGVARCHAR";
    private static final String SQLSERVER_LONGNVARCHAR = "LONGNVARCHAR";
    private static final String SQLSERVER_TEXT = "TEXT";
    private static final String SQLSERVER_NTEXT = "NTEXT";
    private static final String SQLSERVER_XML = "XML";
    private static final String SQLSERVER_BLOB = "BLOB";
    private static final String SQLSERVER_VARBINARY = "VARBINARY";
    private static final String SQLSERVER_INTEGER = "INT";
    private static final String SQLSERVER_INT_IDENTITY = "INT IDENTITY";
    private static final String SQLSERVER_SMALLINT = "SMALLINT";
    private static final String SQLSERVER_TINYINT = "TINYINT";
    private static final String SQLSERVER_BIGINT = "BIGINT";
    private static final String SQLSERVER_FLOAT = "FLOAT";
    private static final String SQLSERVER_REAL = "REAL";
    private static final String SQLSERVER_DOUBLE = "DOUBLE";
    private static final String SQLSERVER_NUMERIC = "NUMERIC";
    private static final String SQLSERVER_DECIMAL = "DECIMAL";
    private static final String SQLSERVER_SMALLMONEY = "SMALLMONEY";
    private static final String SQLSERVER_MONEY = "MONEY";
    private static final String SQLSERVER_TIMESTAMP = "TIMESTAMP";
    private static final String SQLSERVER_DATE = "DATE";
    private static final String SQLSERVER_TIME = "TIME";
    private static final String SQLSERVER_DATETIMEOFFSET = "DATETIMEOFFSET";
    private static final String SQLSERVER_DATETIME2 = "DATETIME2";
    private static final String SQLSERVER_DATETIME = "DATETIME";
    private static final String SQLSERVER_SMALLDATETIME = "SMALLDATETIME";
    private static final String SQLSERVER_BIT = "BIT";

    public static SeaTunnelDataType<?> convertFromColumn(Column column) {
        String typeName;
        switch (typeName = column.typeName().toUpperCase()) {
            case "CHAR": 
            case "VARCHAR": 
            case "NCHAR": 
            case "NVARCHAR": 
            case "STRUCT": 
            case "CLOB": 
            case "LONGVARCHAR": 
            case "LONGNVARCHAR": 
            case "TEXT": 
            case "NTEXT": 
            case "XML": {
                return BasicType.STRING_TYPE;
            }
            case "BLOB": 
            case "VARBINARY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "INT": 
            case "INT IDENTITY": {
                return BasicType.INT_TYPE;
            }
            case "SMALLINT": 
            case "TINYINT": {
                return BasicType.SHORT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "REAL": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": 
            case "FLOAT": {
                return BasicType.DOUBLE_TYPE;
            }
            case "NUMERIC": 
            case "DECIMAL": 
            case "SMALLMONEY": 
            case "MONEY": {
                return new DecimalType(column.length(), column.scale().orElse(0).intValue());
            }
            case "TIMESTAMP": 
            case "DATETIMEOFFSET": 
            case "DATETIME2": 
            case "DATETIME": 
            case "SMALLDATETIME": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "BIT": {
                return BasicType.BOOLEAN_TYPE;
            }
        }
        throw new UnsupportedOperationException(String.format("Don't support SqlSever type '%s' yet, jdbcType:'%s'.", column.typeName(), column.jdbcType()));
    }
}

