/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Optional;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcRowConverter
implements JdbcRowConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcRowConverter.class);

    public abstract String converterName();

    @Override
    public SeaTunnelRow toInternal(ResultSet rs, TableSchema tableSchema) throws SQLException {
        SeaTunnelRowType typeInfo = tableSchema.toPhysicalRowDataType();
        Object[] fields = new Object[typeInfo.getTotalFields()];
        block16: for (int fieldIndex = 0; fieldIndex < typeInfo.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = typeInfo.getFieldType(fieldIndex);
            int resultSetIndex = fieldIndex + 1;
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    fields[fieldIndex] = JdbcUtils.getString(rs, resultSetIndex);
                    continue block16;
                }
                case BOOLEAN: {
                    fields[fieldIndex] = JdbcUtils.getBoolean(rs, resultSetIndex);
                    continue block16;
                }
                case TINYINT: {
                    fields[fieldIndex] = JdbcUtils.getByte(rs, resultSetIndex);
                    continue block16;
                }
                case SMALLINT: {
                    fields[fieldIndex] = JdbcUtils.getShort(rs, resultSetIndex);
                    continue block16;
                }
                case INT: {
                    fields[fieldIndex] = JdbcUtils.getInt(rs, resultSetIndex);
                    continue block16;
                }
                case BIGINT: {
                    fields[fieldIndex] = JdbcUtils.getLong(rs, resultSetIndex);
                    continue block16;
                }
                case FLOAT: {
                    fields[fieldIndex] = JdbcUtils.getFloat(rs, resultSetIndex);
                    continue block16;
                }
                case DOUBLE: {
                    fields[fieldIndex] = JdbcUtils.getDouble(rs, resultSetIndex);
                    continue block16;
                }
                case DECIMAL: {
                    fields[fieldIndex] = JdbcUtils.getBigDecimal(rs, resultSetIndex);
                    continue block16;
                }
                case DATE: {
                    Date sqlDate = JdbcUtils.getDate(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlDate).map(e -> e.toLocalDate()).orElse(null);
                    continue block16;
                }
                case TIME: {
                    Time sqlTime = JdbcUtils.getTime(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTime).map(e -> e.toLocalTime()).orElse(null);
                    continue block16;
                }
                case TIMESTAMP: {
                    Timestamp sqlTimestamp = JdbcUtils.getTimestamp(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTimestamp).map(e -> e.toLocalDateTime()).orElse(null);
                    continue block16;
                }
                case BYTES: {
                    fields[fieldIndex] = JdbcUtils.getBytes(rs, resultSetIndex);
                    continue block16;
                }
                case NULL: {
                    fields[fieldIndex] = null;
                    continue block16;
                }
                default: {
                    throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                }
            }
        }
        return new SeaTunnelRow(fields);
    }

    @Override
    public PreparedStatement toExternal(TableSchema tableSchema, SeaTunnelRow row, PreparedStatement statement) throws SQLException {
        SeaTunnelRowType rowType = tableSchema.toPhysicalRowDataType();
        block16: for (int fieldIndex = 0; fieldIndex < rowType.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = rowType.getFieldType(fieldIndex);
            int statementIndex = fieldIndex + 1;
            Object fieldValue = row.getField(fieldIndex);
            if (fieldValue == null) {
                statement.setObject(statementIndex, null);
                continue;
            }
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    statement.setString(statementIndex, (String)row.getField(fieldIndex));
                    continue block16;
                }
                case BOOLEAN: {
                    statement.setBoolean(statementIndex, (Boolean)row.getField(fieldIndex));
                    continue block16;
                }
                case TINYINT: {
                    statement.setByte(statementIndex, (Byte)row.getField(fieldIndex));
                    continue block16;
                }
                case SMALLINT: {
                    statement.setShort(statementIndex, (Short)row.getField(fieldIndex));
                    continue block16;
                }
                case INT: {
                    statement.setInt(statementIndex, (Integer)row.getField(fieldIndex));
                    continue block16;
                }
                case BIGINT: {
                    statement.setLong(statementIndex, (Long)row.getField(fieldIndex));
                    continue block16;
                }
                case FLOAT: {
                    statement.setFloat(statementIndex, ((Float)row.getField(fieldIndex)).floatValue());
                    continue block16;
                }
                case DOUBLE: {
                    statement.setDouble(statementIndex, (Double)row.getField(fieldIndex));
                    continue block16;
                }
                case DECIMAL: {
                    statement.setBigDecimal(statementIndex, (BigDecimal)row.getField(fieldIndex));
                    continue block16;
                }
                case DATE: {
                    LocalDate localDate = (LocalDate)row.getField(fieldIndex);
                    statement.setDate(statementIndex, Date.valueOf(localDate));
                    continue block16;
                }
                case TIME: {
                    LocalTime localTime = (LocalTime)row.getField(fieldIndex);
                    statement.setTime(statementIndex, Time.valueOf(localTime));
                    continue block16;
                }
                case TIMESTAMP: {
                    LocalDateTime localDateTime = (LocalDateTime)row.getField(fieldIndex);
                    statement.setTimestamp(statementIndex, Timestamp.valueOf(localDateTime));
                    continue block16;
                }
                case BYTES: {
                    statement.setBytes(statementIndex, (byte[])row.getField(fieldIndex));
                    continue block16;
                }
                case NULL: {
                    statement.setNull(statementIndex, 0);
                    continue block16;
                }
                default: {
                    throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                }
            }
        }
        return statement;
    }
}

