/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.kingbase;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;

public class KingbaseTypeMapper
implements JdbcDialectTypeMapper {
    private static final String KB_SMALLSERIAL = "SMALLSERIAL";
    private static final String KB_SERIAL = "SERIAL";
    private static final String KB_BIGSERIAL = "BIGSERIAL";
    private static final String KB_BYTEA = "BYTEA";
    private static final String KB_BYTEA_ARRAY = "_BYTEA";
    private static final String KB_SMALLINT = "INT2";
    private static final String KB_SMALLINT_ARRAY = "_INT2";
    private static final String KB_INTEGER = "INT4";
    private static final String KB_INTEGER_ARRAY = "_INT4";
    private static final String KB_BIGINT = "INT8";
    private static final String KB_BIGINT_ARRAY = "_INT8";
    private static final String KB_REAL = "FLOAT4";
    private static final String KB_REAL_ARRAY = "_FLOAT4";
    private static final String KB_DOUBLE_PRECISION = "FLOAT8";
    private static final String KB_DOUBLE_PRECISION_ARRAY = "_FLOAT8";
    private static final String KB_NUMERIC = "NUMERIC";
    private static final String KB_NUMERIC_ARRAY = "_NUMERIC";
    private static final String KB_BOOLEAN = "BOOL";
    private static final String KB_BOOLEAN_ARRAY = "_BOOL";
    private static final String KB_TIMESTAMP = "TIMESTAMP";
    private static final String KB_TIMESTAMP_ARRAY = "_TIMESTAMP";
    private static final String KB_TIMESTAMPTZ = "TIMESTAMPTZ";
    private static final String KB_TIMESTAMPTZ_ARRAY = "_TIMESTAMPTZ";
    private static final String KB_DATE = "DATE";
    private static final String KB_DATE_ARRAY = "_DATE";
    private static final String KB_TIME = "TIME";
    private static final String KB_TIME_ARRAY = "_TIME";
    private static final String KB_TEXT = "TEXT";
    private static final String KB_TEXT_ARRAY = "_TEXT";
    private static final String KB_CHAR = "BPCHAR";
    private static final String KB_CHAR_ARRAY = "_BPCHAR";
    private static final String KB_CHARACTER = "CHARACTER";
    private static final String KB_CHARACTER_VARYING = "VARCHAR";
    private static final String KB_CHARACTER_VARYING_ARRAY = "_VARCHAR";
    private static final String KB_JSON = "JSON";
    private static final String KB_JSONB = "JSONB";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String kbType = metadata.getColumnTypeName(colIndex).toUpperCase();
        int precision = metadata.getPrecision(colIndex);
        switch (kbType) {
            case "BOOL": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "INT2": {
                return BasicType.SHORT_TYPE;
            }
            case "SMALLSERIAL": 
            case "INT4": 
            case "SERIAL": {
                return BasicType.INT_TYPE;
            }
            case "INT8": 
            case "BIGSERIAL": {
                return BasicType.LONG_TYPE;
            }
            case "FLOAT4": {
                return BasicType.FLOAT_TYPE;
            }
            case "FLOAT8": {
                return BasicType.DOUBLE_TYPE;
            }
            case "NUMERIC": {
                if (precision > 0) {
                    return new DecimalType(precision, metadata.getScale(colIndex));
                }
                return new DecimalType(38, 18);
            }
            case "BPCHAR": 
            case "CHARACTER": 
            case "VARCHAR": 
            case "TEXT": {
                return BasicType.STRING_TYPE;
            }
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw CommonError.convertToSeaTunnelTypeError((String)"KingBase", (String)kbType, (String)jdbcColumnName);
    }
}

