/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.sink;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.shade.com.zaxxer.hikari.HikariDataSource;

public class ConnectionPoolManager {
    private final HikariDataSource connectionPool;
    private final Map<Integer, Connection> connectionMap;

    ConnectionPoolManager(HikariDataSource connectionPool) {
        this.connectionPool = connectionPool;
        this.connectionMap = new ConcurrentHashMap<Integer, Connection>();
    }

    public Connection getConnection(int index) {
        return this.connectionMap.computeIfAbsent(index, i -> {
            try {
                return this.connectionPool.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public boolean containsConnection(int index) {
        return this.connectionMap.containsKey(index);
    }

    public Connection remove(int index) {
        return this.connectionMap.remove(index);
    }

    public String getPoolName() {
        return this.connectionPool.getPoolName();
    }

    public void close() {
        if (!this.connectionPool.isClosed()) {
            this.connectionPool.close();
        }
    }

    public HikariDataSource getConnectionPool() {
        return this.connectionPool;
    }

    public Map<Integer, Connection> getConnectionMap() {
        return this.connectionMap;
    }
}

