/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SourceInfo;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.TxLogPosition;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class SqlServerOffsetContext
implements OffsetContext {
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private final Schema sourceInfoSchema;
    private final SourceInfo sourceInfo;
    private boolean snapshotCompleted;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    private long eventSerialNo;

    public SqlServerOffsetContext(SqlServerConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted, long eventSerialNo, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
        this.sourceInfo = new SourceInfo(connectorConfig);
        this.sourceInfo.setCommitLsn(position.getCommitLsn());
        this.sourceInfo.setChangeLsn(position.getInTxLsn());
        this.sourceInfoSchema = this.sourceInfo.schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            this.sourceInfo.setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.eventSerialNo = eventSerialNo;
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public SqlServerOffsetContext(SqlServerConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted) {
        this(connectorConfig, position, snapshot, snapshotCompleted, 1L, new TransactionContext(), new SignalBasedIncrementalSnapshotContext<TableId>());
    }

    @Override
    public Map<String, ?> getOffset() {
        if (this.sourceInfo.isSnapshot()) {
            return Collect.hashMapOf("snapshot", true, SNAPSHOT_COMPLETED_KEY, this.snapshotCompleted, "commit_lsn", this.sourceInfo.getCommitLsn().toString());
        }
        return this.incrementalSnapshotContext.store(this.transactionContext.store(Collect.hashMapOf("commit_lsn", this.sourceInfo.getCommitLsn().toString(), "change_lsn", this.sourceInfo.getChangeLsn() == null ? null : this.sourceInfo.getChangeLsn().toString(), "event_serial_no", this.eventSerialNo)));
    }

    @Override
    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    @Override
    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public TxLogPosition getChangePosition() {
        return TxLogPosition.valueOf(this.sourceInfo.getCommitLsn(), this.sourceInfo.getChangeLsn());
    }

    public long getEventSerialNo() {
        return this.eventSerialNo;
    }

    public void setChangePosition(TxLogPosition position, int eventCount) {
        this.eventSerialNo = this.getChangePosition().equals(position) ? (this.eventSerialNo += (long)eventCount) : (long)eventCount;
        this.sourceInfo.setCommitLsn(position.getCommitLsn());
        this.sourceInfo.setChangeLsn(position.getInTxLsn());
        this.sourceInfo.setEventSerialNo(this.eventSerialNo);
    }

    @Override
    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    @Override
    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    @Override
    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    @Override
    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    public String toString() {
        return "SqlServerOffsetContext [sourceInfoSchema=" + this.sourceInfoSchema + ", sourceInfo=" + this.sourceInfo + ", snapshotCompleted=" + this.snapshotCompleted + ", eventSerialNo=" + this.eventSerialNo + "]";
    }

    @Override
    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    @Override
    public void event(DataCollectionId tableId, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.setTableId((TableId)tableId);
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public void incrementalSnapshotEvents() {
        this.sourceInfo.setSnapshot(SnapshotRecord.INCREMENTAL);
    }

    @Override
    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public static class Loader
    implements OffsetContext.Loader<SqlServerOffsetContext> {
        private final SqlServerConnectorConfig connectorConfig;

        public Loader(SqlServerConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        @Override
        public SqlServerOffsetContext load(Map<String, ?> offset) {
            Lsn changeLsn = Lsn.valueOf((String)offset.get("change_lsn"));
            Lsn commitLsn = Lsn.valueOf((String)offset.get("commit_lsn"));
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(SqlServerOffsetContext.SNAPSHOT_COMPLETED_KEY));
            Long eventSerialNo = (Long)offset.get("event_serial_no");
            if (eventSerialNo == null) {
                eventSerialNo = 0L;
            }
            return new SqlServerOffsetContext(this.connectorConfig, TxLogPosition.valueOf(commitLsn, changeLsn), snapshot, snapshotCompleted, eventSerialNo, TransactionContext.load(offset), SignalBasedIncrementalSnapshotContext.load(offset));
        }
    }
}

