/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.offset;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.errors.ConnectException;

public abstract class Offset
implements Comparable<Offset>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> offset;

    protected long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
        }
    }

    public boolean isAtOrBefore(Offset that) {
        return this.compareTo(that) <= 0;
    }

    public boolean isBefore(Offset that) {
        return this.compareTo(that) < 0;
    }

    public boolean isAtOrAfter(Offset that) {
        return this.compareTo(that) >= 0;
    }

    public boolean isAfter(Offset that) {
        return this.compareTo(that) > 0;
    }

    public String toString() {
        return this.offset.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Offset)) {
            return false;
        }
        Offset that = (Offset)o;
        return this.offset.equals(that.offset);
    }

    public int hashCode() {
        return Objects.hashCode(this.offset);
    }

    public Map<String, String> getOffset() {
        return this.offset;
    }
}

