/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.debezium.row;

import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationConverter;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationConverterFactory;
import org.apache.seatunnel.connectors.cdc.debezium.MetadataConverter;
import org.apache.seatunnel.connectors.cdc.debezium.utils.TemporalConversions;

public class SeaTunnelRowDebeziumDeserializationConverters
implements Serializable {
    private static final long serialVersionUID = -897499476343410567L;
    protected final DebeziumDeserializationConverter[] physicalConverters;
    protected final MetadataConverter[] metadataConverters;
    protected final String[] fieldNames;

    public SeaTunnelRowDebeziumDeserializationConverters(SeaTunnelRowType physicalDataType, MetadataConverter[] metadataConverters, ZoneId serverTimeZone, DebeziumDeserializationConverterFactory userDefinedConverterFactory) {
        this.metadataConverters = metadataConverters;
        this.physicalConverters = (DebeziumDeserializationConverter[])Arrays.stream(physicalDataType.getFieldTypes()).map(type -> SeaTunnelRowDebeziumDeserializationConverters.createConverter(type, serverTimeZone, userDefinedConverterFactory)).toArray(DebeziumDeserializationConverter[]::new);
        this.fieldNames = physicalDataType.getFieldNames();
    }

    public SeaTunnelRow convert(SourceRecord record, Struct struct, Schema schema) throws Exception {
        int i;
        int arity = this.physicalConverters.length + this.metadataConverters.length;
        SeaTunnelRow row = new SeaTunnelRow(arity);
        for (i = 0; i < this.physicalConverters.length; ++i) {
            String fieldName = this.fieldNames[i];
            Field field = schema.field(fieldName);
            if (field == null) {
                row.setField(i, null);
                continue;
            }
            Object fieldValue = struct.get(fieldName);
            Schema fieldSchema = field.schema();
            Object convertedField = SeaTunnelRowDebeziumDeserializationConverters.convertField(this.physicalConverters[i], fieldValue, fieldSchema);
            row.setField(i, convertedField);
        }
        for (i = 0; i < this.metadataConverters.length; ++i) {
            row.setField(i + this.physicalConverters.length, this.metadataConverters[i].read(record));
        }
        return row;
    }

    private static DebeziumDeserializationConverter createConverter(SeaTunnelDataType<?> type, ZoneId serverTimeZone, DebeziumDeserializationConverterFactory userDefinedConverterFactory) {
        return SeaTunnelRowDebeziumDeserializationConverters.wrapIntoNullableConverter(SeaTunnelRowDebeziumDeserializationConverters.createNotNullConverter(type, serverTimeZone, userDefinedConverterFactory));
    }

    private static DebeziumDeserializationConverter createNotNullConverter(SeaTunnelDataType<?> type, ZoneId serverTimeZone, DebeziumDeserializationConverterFactory userDefinedConverterFactory) {
        Optional<DebeziumDeserializationConverter> converter = userDefinedConverterFactory.createUserDefinedConverter(type, serverTimeZone);
        if (converter.isPresent()) {
            return converter.get();
        }
        switch (type.getSqlType()) {
            case NULL: {
                return new DebeziumDeserializationConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object dbzObj, Schema schema) throws Exception {
                        return null;
                    }
                };
            }
            case BOOLEAN: {
                return SeaTunnelRowDebeziumDeserializationConverters.wrapNumericConverter(SeaTunnelRowDebeziumDeserializationConverters.convertToBoolean());
            }
            case TINYINT: {
                return SeaTunnelRowDebeziumDeserializationConverters.wrapNumericConverter(SeaTunnelRowDebeziumDeserializationConverters.convertToByte());
            }
            case SMALLINT: {
                return SeaTunnelRowDebeziumDeserializationConverters.wrapNumericConverter(SeaTunnelRowDebeziumDeserializationConverters.convertToShort());
            }
            case INT: {
                return SeaTunnelRowDebeziumDeserializationConverters.wrapNumericConverter(SeaTunnelRowDebeziumDeserializationConverters.convertToInt());
            }
            case BIGINT: {
                return SeaTunnelRowDebeziumDeserializationConverters.wrapNumericConverter(SeaTunnelRowDebeziumDeserializationConverters.convertToLong());
            }
            case DATE: {
                return SeaTunnelRowDebeziumDeserializationConverters.convertToDate();
            }
            case TIME: {
                return SeaTunnelRowDebeziumDeserializationConverters.convertToTime();
            }
            case TIMESTAMP: {
                return SeaTunnelRowDebeziumDeserializationConverters.convertToTimestamp(serverTimeZone);
            }
            case FLOAT: {
                return SeaTunnelRowDebeziumDeserializationConverters.wrapNumericConverter(SeaTunnelRowDebeziumDeserializationConverters.convertToFloat());
            }
            case DOUBLE: {
                return SeaTunnelRowDebeziumDeserializationConverters.wrapNumericConverter(SeaTunnelRowDebeziumDeserializationConverters.convertToDouble());
            }
            case STRING: {
                return SeaTunnelRowDebeziumDeserializationConverters.convertToString();
            }
            case BYTES: {
                return SeaTunnelRowDebeziumDeserializationConverters.convertToBinary();
            }
            case DECIMAL: {
                return SeaTunnelRowDebeziumDeserializationConverters.wrapNumericConverter(SeaTunnelRowDebeziumDeserializationConverters.createDecimalConverter());
            }
            case ROW: {
                return SeaTunnelRowDebeziumDeserializationConverters.createRowConverter((SeaTunnelRowType)type, serverTimeZone, userDefinedConverterFactory);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static DebeziumDeserializationConverter convertToBoolean() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Boolean) {
                    return dbzObj;
                }
                if (dbzObj instanceof Byte) {
                    return (Byte)dbzObj != 0;
                }
                if (dbzObj instanceof Short) {
                    return (Short)dbzObj != 0;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).shortValue() != 0;
                }
                return Boolean.parseBoolean(dbzObj.toString());
            }
        };
    }

    private static DebeziumDeserializationConverter convertToByte() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Byte) {
                    return dbzObj;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).byteValue();
                }
                if (dbzObj instanceof Boolean) {
                    return Boolean.TRUE.equals(dbzObj) ? Byte.valueOf("1") : Byte.valueOf("0");
                }
                return Byte.parseByte(dbzObj.toString());
            }
        };
    }

    private static DebeziumDeserializationConverter convertToShort() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Byte) {
                    return dbzObj;
                }
                if (dbzObj instanceof Short) {
                    return dbzObj;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).shortValue();
                }
                return Short.parseShort(dbzObj.toString());
            }
        };
    }

    private static DebeziumDeserializationConverter convertToInt() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Integer) {
                    return dbzObj;
                }
                if (dbzObj instanceof Long) {
                    return ((Long)dbzObj).intValue();
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).intValue();
                }
                return Integer.parseInt(dbzObj.toString());
            }
        };
    }

    private static DebeziumDeserializationConverter convertToLong() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Integer) {
                    return dbzObj;
                }
                if (dbzObj instanceof Long) {
                    return dbzObj;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).longValue();
                }
                return Long.parseLong(dbzObj.toString());
            }
        };
    }

    private static DebeziumDeserializationConverter convertToDouble() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Float) {
                    return dbzObj;
                }
                if (dbzObj instanceof Double) {
                    return dbzObj;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).doubleValue();
                }
                return Double.parseDouble(dbzObj.toString());
            }
        };
    }

    private static DebeziumDeserializationConverter convertToFloat() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Float) {
                    return dbzObj;
                }
                if (dbzObj instanceof Double) {
                    return Float.valueOf(((Double)dbzObj).floatValue());
                }
                if (dbzObj instanceof BigDecimal) {
                    return Float.valueOf(((BigDecimal)dbzObj).floatValue());
                }
                return Float.valueOf(Float.parseFloat(dbzObj.toString()));
            }
        };
    }

    private static DebeziumDeserializationConverter convertToDate() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                return TemporalConversions.toLocalDate(dbzObj);
            }
        };
    }

    private static DebeziumDeserializationConverter convertToTime() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Long) {
                    switch (schema.name()) {
                        case "io.debezium.time.MicroTime": {
                            return LocalTime.ofNanoOfDay((Long)dbzObj * 1000L);
                        }
                        case "io.debezium.time.NanoTime": {
                            return LocalTime.ofNanoOfDay((Long)dbzObj);
                        }
                    }
                } else if (dbzObj instanceof Integer) {
                    return LocalTime.ofNanoOfDay((long)((Integer)dbzObj).intValue() * 1000000L);
                }
                return TemporalConversions.toLocalTime(dbzObj);
            }
        };
    }

    private static DebeziumDeserializationConverter convertToTimestamp(final ZoneId serverTimeZone) {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Long) {
                    switch (schema.name()) {
                        case "io.debezium.time.Timestamp": {
                            return SeaTunnelRowDebeziumDeserializationConverters.toLocalDateTime((Long)dbzObj, 0);
                        }
                        case "io.debezium.time.MicroTimestamp": {
                            long micro = (Long)dbzObj;
                            return SeaTunnelRowDebeziumDeserializationConverters.toLocalDateTime(micro / 1000L, (int)(micro % 1000L * 1000L));
                        }
                        case "io.debezium.time.NanoTimestamp": {
                            long nano = (Long)dbzObj;
                            return SeaTunnelRowDebeziumDeserializationConverters.toLocalDateTime(nano / 1000000L, (int)(nano % 1000000L));
                        }
                    }
                }
                return TemporalConversions.toLocalDateTime(dbzObj, serverTimeZone);
            }
        };
    }

    public static LocalDateTime toLocalDateTime(long millisecond, int nanoOfMillisecond) {
        int date = (int)(millisecond / 86400000L);
        int time = (int)(millisecond % 86400000L);
        if (time < 0) {
            --date;
            time += 86400000;
        }
        long nanoOfDay = (long)time * 1000000L + (long)nanoOfMillisecond;
        LocalDate localDate = LocalDate.ofEpochDay(date);
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
        return LocalDateTime.of(localDate, localTime);
    }

    private static DebeziumDeserializationConverter convertToLocalTimeZoneTimestamp(final ZoneId serverTimeZone) {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof String) {
                    String str = (String)dbzObj;
                    Instant instant = Instant.parse(str);
                    return LocalDateTime.ofInstant(instant, serverTimeZone);
                }
                throw new IllegalArgumentException("Unable to convert to LocalDateTime from unexpected value '" + dbzObj + "' of type " + dbzObj.getClass().getName());
            }
        };
    }

    private static DebeziumDeserializationConverter convertToString() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                return dbzObj.toString();
            }
        };
    }

    private static DebeziumDeserializationConverter convertToBinary() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) throws Exception {
                if (dbzObj instanceof byte[]) {
                    return dbzObj;
                }
                if (dbzObj instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)dbzObj;
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    return bytes;
                }
                throw new UnsupportedOperationException("Unsupported BYTES value type: " + dbzObj.getClass().getSimpleName());
            }
        };
    }

    private static DebeziumDeserializationConverter createDecimalConverter() {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) throws Exception {
                BigDecimal bigDecimal = dbzObj instanceof byte[] ? Decimal.toLogical(schema, (byte[])dbzObj) : (dbzObj instanceof String ? new BigDecimal((String)dbzObj) : (dbzObj instanceof Double ? BigDecimal.valueOf((Double)dbzObj) : (dbzObj instanceof BigDecimal ? (BigDecimal)dbzObj : new BigDecimal(dbzObj.toString()))));
                return bigDecimal;
            }
        };
    }

    private static DebeziumDeserializationConverter createRowConverter(SeaTunnelRowType rowType, ZoneId serverTimeZone, DebeziumDeserializationConverterFactory userDefinedConverterFactory) {
        final DebeziumDeserializationConverter[] fieldConverters = (DebeziumDeserializationConverter[])Arrays.stream(rowType.getFieldTypes()).map(type -> SeaTunnelRowDebeziumDeserializationConverters.createConverter(type, serverTimeZone, userDefinedConverterFactory)).toArray(DebeziumDeserializationConverter[]::new);
        final String[] fieldNames = rowType.getFieldNames();
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) throws Exception {
                Struct struct = (Struct)dbzObj;
                int arity = fieldNames.length;
                SeaTunnelRow row = new SeaTunnelRow(arity);
                for (int i = 0; i < arity; ++i) {
                    String fieldName = fieldNames[i];
                    Object fieldValue = struct.get(fieldName);
                    Field field = schema.field(fieldName);
                    if (field == null) {
                        row.setField(i, null);
                        continue;
                    }
                    Schema fieldSchema = field.schema();
                    Object convertedField = SeaTunnelRowDebeziumDeserializationConverters.convertField(fieldConverters[i], fieldValue, fieldSchema);
                    row.setField(i, convertedField);
                }
                return row;
            }
        };
    }

    private static Object convertField(DebeziumDeserializationConverter fieldConverter, Object fieldValue, Schema fieldSchema) throws Exception {
        if (fieldValue == null) {
            return null;
        }
        return fieldConverter.convert(fieldValue, fieldSchema);
    }

    private static DebeziumDeserializationConverter wrapIntoNullableConverter(final DebeziumDeserializationConverter converter) {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) throws Exception {
                if (dbzObj == null) {
                    return null;
                }
                return converter.convert(dbzObj, schema);
            }
        };
    }

    private static DebeziumDeserializationConverter wrapNumericConverter(final DebeziumDeserializationConverter converter) {
        return new DebeziumDeserializationConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) throws Exception {
                if ("io.debezium.data.VariableScaleDecimal".equals(schema.name())) {
                    SpecialValueDecimal decimal = VariableScaleDecimal.toLogical((Struct)dbzObj);
                    return converter.convert(decimal.getDecimalValue().orElse(BigDecimal.ZERO), schema);
                }
                return converter.convert(dbzObj, schema);
            }
        };
    }
}

