/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.reader.fetch.transactionlog;

import io.debezium.DebeziumException;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.SqlServerStreamingChangeEventSource;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.util.Clock;
import java.util.Map;
import org.apache.seatunnel.connectors.cdc.base.relational.JdbcSourceEventDispatcher;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.FetchTask;
import org.apache.seatunnel.connectors.cdc.base.source.split.IncrementalSplit;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.apache.seatunnel.connectors.cdc.base.source.split.wartermark.WatermarkKind;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.offset.LsnOffset;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.reader.fetch.SqlServerSourceFetchTaskContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.reader.fetch.scan.SqlServerSnapshotFetchTask;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.utils.SqlServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerTransactionLogFetchTask
implements FetchTask<SourceSplitBase> {
    private final IncrementalSplit split;
    private volatile boolean taskRunning = false;

    public SqlServerTransactionLogFetchTask(IncrementalSplit split) {
        this.split = split;
    }

    @Override
    public void execute(FetchTask.Context context) throws Exception {
        SqlServerSourceFetchTaskContext sourceFetchContext = (SqlServerSourceFetchTaskContext)context;
        this.taskRunning = true;
        TransactionLogSplitReadTask transactionLogSplitReadTask = new TransactionLogSplitReadTask(sourceFetchContext.getDbzConnectorConfig(), sourceFetchContext.getDataConnection(), sourceFetchContext.getMetadataConnection(), sourceFetchContext.getDispatcher(), sourceFetchContext.getErrorHandler(), sourceFetchContext.getDatabaseSchema(), this.split);
        TransactionLogSplitChangeEventSourceContext changeEventSourceContext = new TransactionLogSplitChangeEventSourceContext();
        transactionLogSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)changeEventSourceContext, sourceFetchContext.getPartition(), sourceFetchContext.getOffsetContext());
    }

    @Override
    public boolean isRunning() {
        return this.taskRunning;
    }

    @Override
    public void shutdown() {
        this.taskRunning = false;
    }

    @Override
    public SourceSplitBase getSplit() {
        return this.split;
    }

    private class TransactionLogSplitChangeEventSourceContext
    implements ChangeEventSource.ChangeEventSourceContext {
        private TransactionLogSplitChangeEventSourceContext() {
        }

        @Override
        public boolean isRunning() {
            return SqlServerTransactionLogFetchTask.this.taskRunning;
        }
    }

    public static class TransactionLogSplitReadTask
    extends SqlServerStreamingChangeEventSource {
        private static final Logger LOG = LoggerFactory.getLogger(TransactionLogSplitReadTask.class);
        private final IncrementalSplit lsnSplit;
        private final JdbcSourceEventDispatcher dispatcher;
        private final ErrorHandler errorHandler;
        private ChangeEventSource.ChangeEventSourceContext context;

        public TransactionLogSplitReadTask(SqlServerConnectorConfig connectorConfig, SqlServerConnection connection, SqlServerConnection metadataConnection, JdbcSourceEventDispatcher dispatcher, ErrorHandler errorHandler, SqlServerDatabaseSchema schema, IncrementalSplit lsnSplit) {
            super(connectorConfig, connection, metadataConnection, dispatcher, errorHandler, Clock.system(), schema);
            this.lsnSplit = lsnSplit;
            this.dispatcher = dispatcher;
            this.errorHandler = errorHandler;
        }

        @Override
        public void afterHandleLsn(SqlServerPartition partition, Map<String, ?> offset) {
            LsnOffset currentRedoLogOffset;
            if (this.isBoundedRead() && (currentRedoLogOffset = SqlServerUtils.getLsnPosition(offset)).isAtOrAfter(this.lsnSplit.getStopOffset())) {
                try {
                    this.dispatcher.dispatchWatermarkEvent(partition.getSourcePartition(), this.lsnSplit, currentRedoLogOffset, WatermarkKind.END);
                }
                catch (InterruptedException e) {
                    LOG.error("Send signal event error.", (Throwable)e);
                    this.errorHandler.setProducerThrowable(new DebeziumException("Error processing binlog signal event", e));
                }
                ((SqlServerSnapshotFetchTask.SnapshotBinlogSplitChangeEventSourceContext)this.context).finished();
            }
        }

        private boolean isBoundedRead() {
            return !LsnOffset.NO_STOPPING_OFFSET.equals(this.lsnSplit.getStopOffset());
        }

        @Override
        public void execute(ChangeEventSource.ChangeEventSourceContext context, SqlServerPartition partition, SqlServerOffsetContext offsetContext) throws InterruptedException {
            this.context = context;
            super.execute(context, partition, offsetContext);
        }
    }
}

