/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql;

public enum MySqlVersion {
    V_5_5,
    V_5_6,
    V_5_7,
    V_8,
    V_8_4;


    public static MySqlVersion parse(String version) {
        if (version != null) {
            if (version.startsWith("5.5")) {
                return V_5_5;
            }
            if (version.startsWith("5.6")) {
                return V_5_6;
            }
            if (version.startsWith("5.7")) {
                return V_5_7;
            }
            if (version.startsWith("8.0")) {
                return V_8;
            }
            if (version.startsWith("8.4")) {
                return V_8_4;
            }
        }
        throw new UnsupportedOperationException("Unsupported MySQL version: " + version);
    }

    public boolean isBefore(MySqlVersion version) {
        return this.compareTo(version) < 0;
    }

    public boolean isAtOrBefore(MySqlVersion version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isAfter(MySqlVersion version) {
        return this.compareTo(version) > 0;
    }

    public boolean isAtOrAfter(MySqlVersion version) {
        return this.compareTo(version) >= 0;
    }
}

