/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oceanbase;

import com.google.auto.service.AutoService;
import javax.annotation.Nonnull;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectFactory;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql.MysqlDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleDialect;

@AutoService(value={JdbcDialectFactory.class})
public class OceanBaseDialectFactory
implements JdbcDialectFactory {
    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:oceanbase:");
    }

    @Override
    public JdbcDialect create() {
        throw new UnsupportedOperationException("Can't create JdbcDialect without compatible mode for OceanBase");
    }

    @Override
    public JdbcDialect create(@Nonnull String compatibleMode, String fieldIde) {
        if ("oracle".equalsIgnoreCase(compatibleMode)) {
            return new OracleDialect();
        }
        return new MysqlDialect();
    }
}

