/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.redshift;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql.PostgresTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class RedshiftTypeConverter
extends PostgresTypeConverter {
    private static final Logger log = LoggerFactory.getLogger(RedshiftTypeConverter.class);
    public static final String REDSHIFT_SMALLINT = "SMALLINT";
    public static final String REDSHIFT_INTEGER = "INTEGER";
    public static final String REDSHIFT_BIGINT = "BIGINT";
    public static final String REDSHIFT_NUMERIC = "NUMERIC";
    public static final String REDSHIFT_REAL = "REAL";
    public static final String REDSHIFT_DOUBLE_PRECISION = "DOUBLE PRECISION";
    public static final String REDSHIFT_BOOLEAN = "BOOLEAN";
    public static final String REDSHIFT_CHARACTER = "CHARACTER";
    public static final String REDSHIFT_CHARACTER_VARYING = "CHARACTER VARYING";
    public static final String REDSHIFT_VARBYTE = "VARBYTE";
    public static final String REDSHIFT_BINARY_VARYING = "BINARY VARYING";
    public static final String REDSHIFT_TIME = "TIME WITHOUT TIME ZONE";
    public static final String REDSHIFT_TIMETZ = "TIME WITH TIME ZONE";
    public static final String REDSHIFT_TIMESTAMP = "TIMESTAMP WITHOUT TIME ZONE";
    public static final String REDSHIFT_TIMESTAMPTZ = "TIMESTAMP WITH TIME ZONE";
    public static final String REDSHIFT_HLLSKETCH = "HLLSKETCH";
    public static final String REDSHIFT_SUPER = "SUPER";
    public static final int MAX_TIME_SCALE = 6;
    public static final int MAX_TIMESTAMP_SCALE = 6;
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SCALE = 37;
    public static final long MAX_SUPER_LENGTH = 0x1000000L;
    public static final long MAX_HLLSKETCH_LENGTH = 24580L;
    public static final int MAX_CHARACTER_LENGTH = 4096;
    public static final int MAX_CHARACTER_VARYING_LENGTH = 65535;
    public static final long MAX_BINARY_VARYING_LENGTH = 1024000L;
    public static final RedshiftTypeConverter INSTANCE = new RedshiftTypeConverter();

    @Override
    public String identifier() {
        return "Redshift";
    }

    @Override
    public Column convert(BasicTypeDefine typeDefine) {
        String dataType;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (dataType = typeDefine.getDataType().toUpperCase()) {
            case "BOOLEAN": {
                builder.sourceType(REDSHIFT_BOOLEAN);
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "SMALLINT": {
                builder.sourceType(REDSHIFT_SMALLINT);
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "INTEGER": {
                builder.sourceType(REDSHIFT_INTEGER);
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "BIGINT": {
                builder.sourceType(REDSHIFT_BIGINT);
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "REAL": {
                builder.sourceType(REDSHIFT_REAL);
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "DOUBLE PRECISION": {
                builder.sourceType(REDSHIFT_DOUBLE_PRECISION);
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "NUMERIC": {
                Long precision = typeDefine.getPrecision();
                Integer scale = typeDefine.getScale();
                if (precision == null || precision <= 0L) {
                    precision = 38L;
                    scale = 18;
                } else if (precision > 38L) {
                    scale = scale - (int)(precision - 38L);
                    precision = 38L;
                }
                builder.sourceType(String.format("%s(%d,%d)", REDSHIFT_NUMERIC, precision, scale));
                builder.dataType((SeaTunnelDataType)new DecimalType(Math.toIntExact(precision), scale.intValue()));
                break;
            }
            case "CHARACTER": {
                Long characterLength = typeDefine.getLength();
                if (characterLength == null || characterLength <= 0L) {
                    characterLength = 4096L;
                }
                builder.sourceType(String.format("%s(%d)", REDSHIFT_CHARACTER, characterLength));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(characterLength);
                break;
            }
            case "CHARACTER VARYING": {
                Long characterVaryingLength = typeDefine.getLength();
                if (characterVaryingLength == null || characterVaryingLength <= 0L) {
                    characterVaryingLength = 65535L;
                }
                builder.sourceType(String.format("%s(%d)", REDSHIFT_CHARACTER_VARYING, characterVaryingLength));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(characterVaryingLength);
                break;
            }
            case "HLLSKETCH": {
                builder.sourceType(REDSHIFT_HLLSKETCH);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(24580L));
                break;
            }
            case "SUPER": {
                builder.sourceType(REDSHIFT_SUPER);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(0x1000000L));
                break;
            }
            case "VARBYTE": 
            case "BINARY VARYING": {
                builder.sourceType(String.format("%s(%d)", typeDefine.getDataType(), 1024000L));
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(1024000L));
                break;
            }
            case "TIME WITHOUT TIME ZONE": {
                builder.sourceType(REDSHIFT_TIME);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                builder.scale(Integer.valueOf(6));
                break;
            }
            case "TIME WITH TIME ZONE": {
                builder.sourceType(REDSHIFT_TIMETZ);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                builder.scale(Integer.valueOf(6));
                break;
            }
            case "TIMESTAMP WITHOUT TIME ZONE": {
                builder.sourceType(REDSHIFT_TIMESTAMP);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(Integer.valueOf(6));
                break;
            }
            case "TIMESTAMP WITH TIME ZONE": {
                builder.sourceType(REDSHIFT_TIMESTAMPTZ);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(Integer.valueOf(6));
                break;
            }
            default: {
                try {
                    return super.convert(typeDefine);
                }
                catch (SeaTunnelRuntimeException e) {
                    throw CommonError.convertToSeaTunnelTypeError((String)"Redshift", (String)typeDefine.getDataType(), (String)typeDefine.getName());
                }
            }
        }
        return builder.build();
    }

    @Override
    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType(REDSHIFT_BOOLEAN);
                builder.dataType(REDSHIFT_BOOLEAN);
                break;
            }
            case TINYINT: 
            case SMALLINT: {
                builder.columnType(REDSHIFT_SMALLINT);
                builder.dataType(REDSHIFT_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(REDSHIFT_INTEGER);
                builder.dataType(REDSHIFT_INTEGER);
                break;
            }
            case BIGINT: {
                builder.columnType(REDSHIFT_BIGINT);
                builder.dataType(REDSHIFT_BIGINT);
                break;
            }
            case FLOAT: {
                builder.columnType(REDSHIFT_REAL);
                builder.dataType(REDSHIFT_REAL);
                break;
            }
            case DOUBLE: {
                builder.columnType(REDSHIFT_DOUBLE_PRECISION);
                builder.dataType(REDSHIFT_DOUBLE_PRECISION);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 38L;
                    scale = 18;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 38L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 38L));
                    precision = 38L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 38, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 37) {
                    scale = 37;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 37, precision, scale});
                }
                builder.columnType(String.format("%s(%d,%d)", REDSHIFT_NUMERIC, precision, scale));
                builder.dataType(REDSHIFT_NUMERIC);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(String.format("%s(%d)", REDSHIFT_CHARACTER_VARYING, 65535));
                    builder.dataType(REDSHIFT_CHARACTER_VARYING);
                    builder.length(Long.valueOf(65535L));
                    break;
                }
                if (column.getColumnLength() <= 65535L) {
                    builder.columnType(String.format("%s(%d)", REDSHIFT_CHARACTER_VARYING, column.getColumnLength()));
                    builder.dataType(REDSHIFT_CHARACTER_VARYING);
                    builder.length(column.getColumnLength());
                    break;
                }
                log.warn("The length of string column {} is {}, which exceeds the maximum length of {}, the length will be set to {}", new Object[]{column.getName(), column.getColumnLength(), 0x1000000L, 0x1000000L});
                builder.columnType(REDSHIFT_SUPER);
                builder.dataType(REDSHIFT_SUPER);
                break;
            }
            case BYTES: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(String.format("%s(%d)", REDSHIFT_BINARY_VARYING, 1024000L));
                    builder.dataType(REDSHIFT_BINARY_VARYING);
                    break;
                }
                if (column.getColumnLength() <= 1024000L) {
                    builder.columnType(String.format("%s(%d)", REDSHIFT_BINARY_VARYING, column.getColumnLength()));
                    builder.dataType(REDSHIFT_BINARY_VARYING);
                    builder.length(column.getColumnLength());
                    break;
                }
                builder.columnType(String.format("%s(%d)", REDSHIFT_BINARY_VARYING, 1024000L));
                builder.dataType(REDSHIFT_BINARY_VARYING);
                log.warn("The length of binary column {} is {}, which exceeds the maximum length of {}, the length will be set to {}", new Object[]{column.getName(), column.getColumnLength(), 1024000L, 1024000L});
                break;
            }
            case TIME: {
                Integer timeScale = column.getScale();
                if (timeScale != null && timeScale > 6) {
                    timeScale = 6;
                    log.warn("The time column {} type time({}) is out of range, which exceeds the maximum scale of {}, it will be converted to time({})", new Object[]{column.getName(), column.getScale(), 37, timeScale});
                }
                builder.columnType(REDSHIFT_TIME);
                builder.dataType(REDSHIFT_TIME);
                builder.scale(timeScale);
                break;
            }
            case TIMESTAMP: {
                Integer timestampScale = column.getScale();
                if (timestampScale != null && timestampScale > 6) {
                    timestampScale = 6;
                    log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 6, timestampScale});
                }
                builder.columnType(REDSHIFT_TIMESTAMP);
                builder.dataType(REDSHIFT_TIMESTAMP);
                builder.scale(timestampScale);
                break;
            }
            case MAP: 
            case ARRAY: 
            case ROW: {
                builder.columnType(REDSHIFT_SUPER);
                builder.dataType(REDSHIFT_SUPER);
                break;
            }
            default: {
                try {
                    return super.reconvert(column);
                }
                catch (SeaTunnelRuntimeException e) {
                    throw CommonError.convertToConnectorTypeError((String)"Redshift", (String)column.getDataType().getSqlType().name(), (String)column.getName());
                }
            }
        }
        return builder.build();
    }
}

