/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.transaction.xa.Xid;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

final class XidImpl
implements Xid,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final int formatId;
    private final byte[] globalTransactionId;
    private final byte[] branchQualifier;

    public XidImpl(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        Preconditions.checkArgument((globalTransactionId.length <= 64 ? 1 : 0) != 0);
        Preconditions.checkArgument((branchQualifier.length <= 64 ? 1 : 0) != 0);
        this.formatId = formatId;
        this.globalTransactionId = Arrays.copyOf(globalTransactionId, globalTransactionId.length);
        this.branchQualifier = Arrays.copyOf(branchQualifier, branchQualifier.length);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XidImpl)) {
            return false;
        }
        XidImpl xid = (XidImpl)o;
        return this.formatId == xid.formatId && Arrays.equals(this.globalTransactionId, xid.globalTransactionId) && Arrays.equals(this.branchQualifier, xid.branchQualifier);
    }

    public int hashCode() {
        int number = 31;
        int result = Objects.hash(this.formatId);
        result = 31 * result + Arrays.hashCode(this.globalTransactionId);
        result = 31 * result + Arrays.hashCode(this.branchQualifier);
        return result;
    }

    public String toString() {
        return this.formatId + ":" + XidImpl.byteToHexString(this.globalTransactionId) + ":" + XidImpl.byteToHexString(this.branchQualifier);
    }

    public static String byteToHexString(byte[] bytes, int start, int end) {
        int number0xf0 = 240;
        int number0x0f = 15;
        int number4 = 4;
        if (bytes == null) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "bytes == null");
        }
        int length = end - start;
        char[] out = new char[length * 2];
        int j = 0;
        for (int i = start; i < end; ++i) {
            out[j++] = HEX_CHARS[(0xF0 & bytes[i]) >>> 4];
            out[j++] = HEX_CHARS[0xF & bytes[i]];
        }
        return new String(out);
    }

    public static String byteToHexString(byte[] bytes) {
        return XidImpl.byteToHexString(bytes, 0, bytes.length);
    }
}

