/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.DynamicChunkSplitter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.FixedChunkSplitter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChunkSplitter
implements AutoCloseable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ChunkSplitter.class);
    protected JdbcSourceConfig config;
    protected final JdbcConnectionProvider connectionProvider;
    protected final JdbcDialect jdbcDialect;
    private final int fetchSize;
    private final boolean autoCommit;

    public ChunkSplitter(JdbcSourceConfig config) {
        this.config = config;
        this.autoCommit = config.getJdbcConnectionConfig().isAutoCommit();
        this.fetchSize = config.getFetchSize();
        this.jdbcDialect = JdbcDialectLoader.load(config.getJdbcConnectionConfig().getUrl(), config.getCompatibleMode());
        this.connectionProvider = this.jdbcDialect.getJdbcConnectionProvider(config.getJdbcConnectionConfig());
    }

    public static ChunkSplitter create(JdbcSourceConfig config) {
        log.info("Switch to {} chunk splitter", (Object)(config.isUseDynamicSplitter() ? "dynamic" : "fixed"));
        return config.isUseDynamicSplitter() ? new DynamicChunkSplitter(config) : new FixedChunkSplitter(config);
    }

    @Override
    public synchronized void close() {
        if (this.connectionProvider != null) {
            this.connectionProvider.closeConnection();
        }
    }

    public Collection<JdbcSourceSplit> generateSplits(JdbcSourceTable table) throws Exception {
        Collection<JdbcSourceSplit> splits;
        log.info("Start splitting table {} into chunks...", (Object)table.getTablePath());
        long start = System.currentTimeMillis();
        Optional<SeaTunnelRowType> splitKeyOptional = this.findSplitKey(table);
        if (!splitKeyOptional.isPresent()) {
            JdbcSourceSplit split = this.createSingleSplit(table);
            splits = Collections.singletonList(split);
        } else {
            if (splitKeyOptional.get().getTotalFields() != 1) {
                throw new UnsupportedOperationException("Currently, only support one split key");
            }
            splits = this.createSplits(table, splitKeyOptional.get());
        }
        long end = System.currentTimeMillis();
        log.info("Split table {} into {} chunks, time cost: {}ms.", new Object[]{table.getTablePath(), splits.size(), end - start});
        return splits;
    }

    protected abstract Collection<JdbcSourceSplit> createSplits(JdbcSourceTable var1, SeaTunnelRowType var2) throws SQLException, Exception;

    public PreparedStatement generateSplitStatement(JdbcSourceSplit split, TableSchema schema) throws SQLException {
        if (split.getSplitKeyName() == null) {
            return this.createSingleSplitStatement(split);
        }
        return this.createSplitStatement(split, schema);
    }

    protected abstract PreparedStatement createSplitStatement(JdbcSourceSplit var1, TableSchema var2) throws SQLException;

    protected PreparedStatement createPreparedStatement(String sql) throws SQLException {
        Connection connection = this.getOrEstablishConnection();
        if (connection.getAutoCommit() != this.autoCommit) {
            connection.setAutoCommit(this.autoCommit);
        }
        if (StringUtils.isNotBlank(this.config.getWhereConditionClause())) {
            sql = String.format("SELECT * FROM (%s) tmp %s", sql, this.config.getWhereConditionClause());
        }
        log.debug("Prepared statement: {}", (Object)sql);
        return this.jdbcDialect.creatPreparedStatement(connection, sql, this.fetchSize);
    }

    protected Connection getOrEstablishConnection() throws SQLException {
        try {
            return this.connectionProvider.getOrEstablishConnection();
        }
        catch (ClassNotFoundException e) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.CLASS_NOT_FOUND, "JDBC-Class not found. - " + e.getMessage(), e);
        }
    }

    protected JdbcSourceSplit createSingleSplit(JdbcSourceTable table) {
        return new JdbcSourceSplit(table.getTablePath(), this.createSplitId(table.getTablePath(), 0), table.getQuery(), null, null, null, null);
    }

    protected PreparedStatement createSingleSplitStatement(JdbcSourceSplit split) throws SQLException {
        String splitQuery = split.getSplitQuery();
        if (StringUtils.isEmpty(splitQuery)) {
            splitQuery = String.format("SELECT * FROM %s", this.jdbcDialect.tableIdentifier(split.getTablePath()));
        }
        return this.createPreparedStatement(splitQuery);
    }

    protected Object queryMin(JdbcSourceTable table, String columnName, Object excludedLowerBound) throws SQLException {
        Map<String, Column> columns = table.getCatalogTable().getTableSchema().getColumns().stream().collect(Collectors.toMap(c -> c.getName(), c -> c));
        Column column = columns.get(columnName);
        columnName = this.jdbcDialect.quoteIdentifier(columnName);
        columnName = this.jdbcDialect.convertType(columnName, column.getSourceType());
        String minQuery = StringUtils.isNotBlank(table.getQuery()) ? String.format("SELECT MIN(%s) FROM (%s) tmp WHERE %s > ?", columnName, table.getQuery(), columnName) : String.format("SELECT MIN(%s) FROM %s WHERE %s > ?", columnName, this.jdbcDialect.tableIdentifier(table.getTablePath()), columnName);
        Throwable throwable = null;
        try (PreparedStatement ps = this.getOrEstablishConnection().prepareStatement(minQuery);){
            Throwable throwable2;
            ResultSet rs;
            block25: {
                Object object;
                block26: {
                    block27: {
                        ps.setObject(1, excludedLowerBound);
                        rs = ps.executeQuery();
                        throwable2 = null;
                        if (!rs.next()) break block25;
                        object = rs.getObject(1);
                        if (rs == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    rs.close();
                }
                return object;
            }
            try {
                try {
                    try {
                        throw new SQLException(String.format("No result returned after running query [%s]", minQuery));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (rs != null) {
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            rs.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected Pair<Object, Object> queryMinMax(JdbcSourceTable table, String columnName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Optional<SeaTunnelRowType> findSplitKey(JdbcSourceTable table) {
        List uniqueKeys;
        List constraintKeys;
        TableSchema schema = table.getCatalogTable().getTableSchema();
        List columns = schema.getColumns();
        Map<String, Column> columnMap = columns.stream().collect(Collectors.toMap(Column::getName, column -> column, (c1, c2) -> c1));
        if (table.getPartitionColumn() != null) {
            String partitionColumn = table.getPartitionColumn();
            Column column2 = columnMap.get(partitionColumn);
            if (column2 == null) {
                throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, String.format("Partitioned column(%s) don't exist in the table columns", partitionColumn));
            }
            if (!this.isSupportSplitColumn(column2)) {
                throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, String.format("%s is not numeric/string type", partitionColumn));
            }
            return Optional.of(new SeaTunnelRowType(new String[]{partitionColumn}, new SeaTunnelDataType[]{column2.getDataType()}));
        }
        PrimaryKey pk = schema.getPrimaryKey();
        if (pk != null) {
            for (String pkField : pk.getColumnNames()) {
                Column column3 = columnMap.get(pkField);
                if (!this.isSupportSplitColumn(column3)) continue;
                return Optional.of(new SeaTunnelRowType(new String[]{pkField}, new SeaTunnelDataType[]{column3.getDataType()}));
            }
        }
        if ((constraintKeys = schema.getConstraintKeys()) != null && !(uniqueKeys = constraintKeys.stream().filter(constraintKey -> constraintKey.getConstraintType() == ConstraintKey.ConstraintType.UNIQUE_KEY).collect(Collectors.toList())).isEmpty()) {
            for (ConstraintKey uniqueKey : uniqueKeys) {
                for (ConstraintKey.ConstraintKeyColumn uniqueKeyColumn : uniqueKey.getColumnNames()) {
                    String uniqueKeyColumnName = uniqueKeyColumn.getColumnName();
                    Column column4 = columnMap.get(uniqueKeyColumnName);
                    if (!this.isSupportSplitColumn(column4)) continue;
                    return Optional.of(new SeaTunnelRowType(new String[]{uniqueKeyColumnName}, new SeaTunnelDataType[]{column4.getDataType()}));
                }
            }
        }
        log.warn("No split key found for table {}", (Object)table.getTablePath());
        return Optional.empty();
    }

    protected boolean isSupportSplitColumn(Column splitColumn) {
        SeaTunnelDataType dataType = splitColumn.getDataType();
        switch (dataType.getSqlType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case STRING: 
            case DATE: {
                return true;
            }
        }
        return false;
    }

    protected String createSplitId(TablePath tablePath, int index) {
        return String.format("%s-%s", tablePath, index);
    }

    private static /* synthetic */ Column lambda$queryMinMax$3(Column c) {
        return c;
    }

    private static /* synthetic */ String lambda$queryMinMax$2(Column c) {
        return c.getName();
    }
}

