/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.JdbcInputFormat;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSourceReader
implements SourceReader<SeaTunnelRow, JdbcSourceSplit> {
    private static final Logger log = LoggerFactory.getLogger(JdbcSourceReader.class);
    private final SourceReader.Context context;
    private final JdbcInputFormat inputFormat;
    private final Deque<JdbcSourceSplit> splits = new ConcurrentLinkedDeque<JdbcSourceSplit>();
    private volatile boolean noMoreSplit;

    public JdbcSourceReader(SourceReader.Context context, JdbcSourceConfig config, Map<TablePath, CatalogTable> tables) {
        this.inputFormat = new JdbcInputFormat(config, tables);
        this.context = context;
    }

    public void open() throws Exception {
        this.inputFormat.openInputFormat();
    }

    public void close() throws IOException {
        this.inputFormat.closeInputFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> output) throws Exception {
        Object object = output.getCheckpointLock();
        synchronized (object) {
            JdbcSourceSplit split = this.splits.poll();
            if (null != split) {
                try {
                    this.inputFormat.open(split);
                    while (!this.inputFormat.reachedEnd()) {
                        SeaTunnelRow seaTunnelRow = this.inputFormat.nextRecord();
                        output.collect((Object)seaTunnelRow);
                    }
                }
                finally {
                    this.inputFormat.close();
                }
            } else if (this.noMoreSplit && this.splits.isEmpty()) {
                log.info("Closed the bounded jdbc source");
                this.context.signalNoMoreElement();
            } else {
                Thread.sleep(1000L);
            }
        }
    }

    public List<JdbcSourceSplit> snapshotState(long checkpointId) throws Exception {
        return new ArrayList<JdbcSourceSplit>(this.splits);
    }

    public void addSplits(List<JdbcSourceSplit> splits) {
        this.splits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

