/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.offset;

import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.jdbc.JdbcConnection;
import java.util.Map;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.config.SqlServerSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.config.SqlServerSourceConfigFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.SqlServerDialect;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.offset.LsnOffset;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.utils.SqlServerUtils;

public class LsnOffsetFactory
extends OffsetFactory {
    private final SqlServerSourceConfig sourceConfig;
    private final SqlServerDialect dialect;

    public LsnOffsetFactory(SqlServerSourceConfigFactory configFactory, SqlServerDialect dialect) {
        this.sourceConfig = configFactory.create(0);
        this.dialect = dialect;
    }

    @Override
    public Offset earliest() {
        return LsnOffset.INITIAL_OFFSET;
    }

    @Override
    public Offset neverStop() {
        return LsnOffset.NO_STOPPING_OFFSET;
    }

    @Override
    public Offset latest() {
        LsnOffset lsnOffset;
        block8: {
            JdbcConnection jdbcConnection = this.dialect.openJdbcConnection(this.sourceConfig);
            try {
                lsnOffset = SqlServerUtils.currentLsn((SqlServerConnection)jdbcConnection);
                if (jdbcConnection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbcConnection != null) {
                        try {
                            jdbcConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Read the binlog offset error", e);
                }
            }
            jdbcConnection.close();
        }
        return lsnOffset;
    }

    @Override
    public Offset specific(Map<String, String> offset) {
        return LsnOffset.valueOf(offset.get("commit_lsn"));
    }

    @Override
    public Offset specific(String filename, Long position) {
        throw new UnsupportedOperationException("not supported create new Offset by filename and position.");
    }

    @Override
    public Offset timestamp(long timestamp) {
        throw new UnsupportedOperationException("not supported create new Offset by timestamp.");
    }
}

