/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PreviewResult;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.SQLPreviewResult;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcCatalog.class);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcCatalog.class);
    protected static final Set<String> SYS_DATABASES = new HashSet<String>();
    protected static final Set<String> EXCLUDED_SCHEMAS = new HashSet<String>();
    protected final String catalogName;
    protected final String defaultDatabase;
    protected final String username;
    protected final String pwd;
    protected final String baseUrl;
    protected final String suffix;
    protected final String defaultUrl;
    protected final Optional<String> defaultSchema;
    protected final Map<String, Connection> connectionMap;

    public AbstractJdbcCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo, String defaultSchema) {
        Preconditions.checkArgument(StringUtils.isNotBlank(username));
        Preconditions.checkArgument(StringUtils.isNotBlank(urlInfo.getUrlWithoutDatabase()));
        this.catalogName = catalogName;
        this.defaultDatabase = urlInfo.getDefaultDatabase().orElse(null);
        this.username = username;
        this.pwd = pwd;
        this.baseUrl = urlInfo.getUrlWithoutDatabase();
        this.defaultUrl = urlInfo.getOrigin();
        this.suffix = urlInfo.getSuffix();
        this.defaultSchema = Optional.ofNullable(defaultSchema);
        this.connectionMap = new ConcurrentHashMap<String, Connection>();
    }

    public String name() {
        return this.catalogName;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    protected Connection getConnection(String url) {
        if (this.connectionMap.containsKey(url)) {
            return this.connectionMap.get(url);
        }
        try {
            Connection connection = DriverManager.getConnection(url, this.username, this.pwd);
            this.connectionMap.put(url, connection);
            return connection;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed connecting to %s via JDBC.", url), (Throwable)e);
        }
    }

    public void open() throws CatalogException {
        this.getConnection(this.defaultUrl);
        LOG.info("Catalog {} established connection to {}", (Object)this.catalogName, (Object)this.defaultUrl);
    }

    public void close() throws CatalogException {
        for (Map.Entry<String, Connection> entry : this.connectionMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (SQLException e) {
                throw new CatalogException(String.format("Failed to close %s via JDBC.", entry.getKey()), (Throwable)e);
            }
        }
        this.connectionMap.clear();
        LOG.info("Catalog {} closing", (Object)this.catalogName);
    }

    protected String getSelectColumnsSql(TablePath tablePath) {
        throw new UnsupportedOperationException();
    }

    protected Column buildColumn(ResultSet resultSet) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected TableIdentifier getTableIdentifier(TablePath tablePath) {
        return TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getSchemaName(), (String)tablePath.getTableName());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        String dbUrl = StringUtils.isNotBlank(tablePath.getDatabaseName()) ? this.getUrlFromDatabaseName(tablePath.getDatabaseName()) : this.getUrlFromDatabaseName(this.defaultDatabase);
        Connection conn = this.getConnection(dbUrl);
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            Optional<PrimaryKey> primaryKey = this.getPrimaryKey(metaData, tablePath);
            List<ConstraintKey> constraintKeys = this.getConstraintKeys(metaData, tablePath);
            try (PreparedStatement ps = conn.prepareStatement(this.getSelectColumnsSql(tablePath));){
                CatalogTable catalogTable;
                block16: {
                    ResultSet resultSet = ps.executeQuery();
                    try {
                        TableSchema.Builder builder = TableSchema.builder();
                        this.buildColumnsWithErrorCheck(tablePath, resultSet, builder);
                        primaryKey.ifPresent(arg_0 -> ((TableSchema.Builder)builder).primaryKey(arg_0));
                        constraintKeys.forEach(arg_0 -> ((TableSchema.Builder)builder).constraintKey(arg_0));
                        TableIdentifier tableIdentifier = this.getTableIdentifier(tablePath);
                        catalogTable = CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)builder.build(), this.buildConnectorOptions(tablePath), Collections.emptyList(), (String)"", (String)this.catalogName);
                        if (resultSet == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return catalogTable;
            }
        }
        catch (SeaTunnelRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    protected void buildColumnsWithErrorCheck(TablePath tablePath, ResultSet resultSet, TableSchema.Builder builder) throws SQLException {
        LinkedHashMap<String, String> unsupported = new LinkedHashMap<String, String>();
        while (resultSet.next()) {
            try {
                builder.column(this.buildColumn(resultSet));
            }
            catch (SeaTunnelRuntimeException e) {
                if (e.getSeaTunnelErrorCode().equals(CommonErrorCode.CONVERT_TO_SEATUNNEL_TYPE_ERROR_SIMPLE)) {
                    unsupported.put((String)e.getParams().get("field"), (String)e.getParams().get("dataType"));
                    continue;
                }
                throw e;
            }
        }
        if (!unsupported.isEmpty()) {
            throw CommonError.getCatalogTableWithUnsupportedType((String)this.catalogName, (String)tablePath.getFullName(), unsupported);
        }
    }

    protected Optional<PrimaryKey> getPrimaryKey(DatabaseMetaData metaData, TablePath tablePath) throws SQLException {
        return this.getPrimaryKey(metaData, tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName());
    }

    protected Optional<PrimaryKey> getPrimaryKey(DatabaseMetaData metaData, String database, String schema, String table) throws SQLException {
        return CatalogUtils.getPrimaryKey(metaData, TablePath.of((String)database, (String)schema, (String)table));
    }

    protected List<ConstraintKey> getConstraintKeys(DatabaseMetaData metaData, TablePath tablePath) throws SQLException {
        return this.getConstraintKeys(metaData, tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName());
    }

    protected List<ConstraintKey> getConstraintKeys(DatabaseMetaData metaData, String database, String schema, String table) throws SQLException {
        return CatalogUtils.getConstraintKeys(metaData, TablePath.of((String)database, (String)schema, (String)table));
    }

    protected String getListDatabaseSql() {
        throw new UnsupportedOperationException();
    }

    protected String getDatabaseWithConditionSql(String databaseName) {
        throw CommonError.unsupportedMethod((String)this.catalogName, (String)"getDatabaseWithConditionSql");
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            return this.queryString(this.defaultUrl, this.getListDatabaseSql(), rs -> {
                String s2 = rs.getString(1);
                return SYS_DATABASES.contains(s2) ? null : s2;
            });
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        if (StringUtils.isBlank(databaseName)) {
            return false;
        }
        if (SYS_DATABASES.contains(databaseName)) {
            return false;
        }
        try {
            return this.querySQLResultExists(this.getUrlFromDatabaseName(databaseName), this.getDatabaseWithConditionSql(databaseName));
        }
        catch (SeaTunnelRuntimeException e) {
            if (e.getSeaTunnelErrorCode().getCode().equals(CommonErrorCode.UNSUPPORTED_METHOD.getCode())) {
                log.warn("The catalog: {} is not supported the getDatabaseWithConditionSql for databaseExists", (Object)this.catalogName);
                return this.listDatabases().contains(databaseName);
            }
            throw e;
        }
    }

    protected String getListTableSql(String databaseName) {
        throw new UnsupportedOperationException();
    }

    protected String getTableWithConditionSql(TablePath tablePath) {
        throw CommonError.unsupportedMethod((String)this.catalogName, (String)"getTableWithConditionSql");
    }

    protected String getTableName(ResultSet rs) throws SQLException {
        String schemaName = rs.getString(1);
        String tableName = rs.getString(2);
        if (StringUtils.isNotBlank(schemaName) && !SYS_DATABASES.contains(schemaName)) {
            return schemaName + "." + tableName;
        }
        return null;
    }

    protected String getTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName();
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        String dbUrl = this.getUrlFromDatabaseName(databaseName);
        try {
            return this.queryString(dbUrl, this.getListTableSql(databaseName), this::getTableName);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        String databaseName = tablePath.getDatabaseName();
        if (EXCLUDED_SCHEMAS.contains(tablePath.getSchemaName())) {
            return false;
        }
        try {
            return this.querySQLResultExists(this.getUrlFromDatabaseName(databaseName), this.getTableWithConditionSql(tablePath));
        }
        catch (SeaTunnelRuntimeException e1) {
            if (e1.getSeaTunnelErrorCode().getCode().equals(CommonErrorCode.UNSUPPORTED_METHOD.getCode())) {
                log.warn("The catalog: {} is not supported the getTableWithConditionSql for tableExists ", (Object)this.catalogName);
                try {
                    return this.databaseExists(tablePath.getDatabaseName()) && this.listTables(tablePath.getDatabaseName()).contains(this.getTableName(tablePath));
                }
                catch (DatabaseNotExistException e2) {
                    return false;
                }
            }
            throw e1;
        }
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.createTable(tablePath, table, ignoreIfExists, true);
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists, boolean createIndex) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath, "Table path cannot be null");
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.catalogName, tablePath.getDatabaseName());
        }
        if (this.defaultSchema.isPresent()) {
            tablePath = new TablePath(tablePath.getDatabaseName(), this.defaultSchema.get(), tablePath.getTableName());
        }
        if (this.tableExists(tablePath)) {
            if (ignoreIfExists) {
                return;
            }
            throw new TableAlreadyExistException(this.catalogName, tablePath);
        }
        this.createTableInternal(tablePath, table, createIndex);
    }

    protected String getCreateTableSql(TablePath tablePath, CatalogTable table, boolean createIndex) {
        throw new UnsupportedOperationException();
    }

    protected List<String> getCreateTableSqls(TablePath tablePath, CatalogTable table, boolean createIndex) {
        return Collections.singletonList(this.getCreateTableSql(tablePath, table, createIndex));
    }

    protected void createTableInternal(TablePath tablePath, CatalogTable table, boolean createIndex) throws CatalogException {
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        try {
            List<String> createTableSqlList = this.getCreateTableSqls(tablePath, table, createIndex);
            for (String sql : createTableSqlList) {
                this.executeInternal(dbUrl, sql);
            }
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed creating table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath, "Table path cannot be null");
        if (!this.tableExists(tablePath)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        this.dropTableInternal(tablePath);
    }

    protected String getDropTableSql(TablePath tablePath) {
        throw new UnsupportedOperationException();
    }

    protected void dropTableInternal(TablePath tablePath) throws CatalogException {
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        try {
            this.executeInternal(dbUrl, this.getDropTableSql(tablePath));
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed dropping table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        Preconditions.checkNotNull(tablePath, "Table path cannot be null");
        Preconditions.checkNotNull(tablePath.getDatabaseName(), "Database name cannot be null");
        if (this.databaseExists(tablePath.getDatabaseName())) {
            if (ignoreIfExists) {
                return;
            }
            throw new DatabaseAlreadyExistException(this.catalogName, tablePath.getDatabaseName());
        }
        this.createDatabaseInternal(tablePath.getDatabaseName());
    }

    protected String getCreateDatabaseSql(String databaseName) {
        throw new UnsupportedOperationException();
    }

    protected void createDatabaseInternal(String databaseName) {
        try {
            this.executeInternal(this.defaultUrl, this.getCreateDatabaseSql(databaseName));
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed creating database %s in catalog %s", databaseName, this.catalogName), (Throwable)e);
        }
    }

    protected void closeDatabaseConnection(String databaseName) {
        String dbUrl = this.getUrlFromDatabaseName(databaseName);
        try {
            Connection connection = this.connectionMap.remove(dbUrl);
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed to close %s via JDBC.", dbUrl), (Throwable)e);
        }
    }

    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath, "Table path cannot be null");
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new DatabaseNotExistException(this.catalogName, tablePath.getDatabaseName());
        }
        this.truncateTableInternal(tablePath);
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath, "Table path cannot be null");
        Preconditions.checkNotNull(tablePath.getDatabaseName(), "Database name cannot be null");
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new DatabaseNotExistException(this.catalogName, tablePath.getDatabaseName());
        }
        this.dropDatabaseInternal(tablePath.getDatabaseName());
    }

    protected String getDropDatabaseSql(String databaseName) {
        throw new UnsupportedOperationException();
    }

    protected void dropDatabaseInternal(String databaseName) throws CatalogException {
        try {
            this.executeInternal(this.defaultUrl, this.getDropDatabaseSql(databaseName));
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed dropping database %s in catalog %s", databaseName, this.catalogName), (Throwable)e);
        }
    }

    protected String getUrlFromDatabaseName(String databaseName) {
        String url = this.baseUrl.endsWith("/") ? this.baseUrl : this.baseUrl + "/";
        return url + databaseName + this.suffix;
    }

    protected String getOptionTableName(TablePath tablePath) {
        return tablePath.getFullName();
    }

    protected Map<String, String> buildConnectorOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>(8);
        options.put("connector", "jdbc");
        options.put("url", this.getUrlFromDatabaseName(tablePath.getDatabaseName()));
        options.put("table-name", this.getOptionTableName(tablePath));
        return options;
    }

    protected List<String> queryString(String url, String sql, ResultSetConsumer<String> consumer) throws SQLException {
        try (PreparedStatement ps = this.getConnection(url).prepareStatement(sql);){
            ArrayList<String> result = new ArrayList<String>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String value = consumer.apply(rs);
                if (value == null) continue;
                result.add(value);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean querySQLResultExists(String dbUrl, String sql) {
        try (PreparedStatement stmt = this.getConnection(dbUrl).prepareStatement(sql);){
            boolean bl;
            block14: {
                ResultSet rs = stmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (Exception e) {
            log.info("query exists error", (Throwable)e);
            return false;
        }
    }

    protected boolean executeInternal(String url, String sql) throws SQLException {
        LOG.info("Execute sql : {}", (Object)sql);
        try (PreparedStatement ps = this.getConnection(url).prepareStatement(sql);){
            boolean bl = ps.execute();
            return bl;
        }
    }

    public CatalogTable getTable(String sqlQuery) throws SQLException {
        Connection defaultConnection = this.getConnection(this.defaultUrl);
        return CatalogUtils.getCatalogTable(defaultConnection, sqlQuery);
    }

    protected void truncateTableInternal(TablePath tablePath) throws CatalogException {
        try {
            this.executeInternal(this.defaultUrl, this.getTruncateTableSql(tablePath));
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed truncate table %s in catalog %s", tablePath.getFullName(), this.catalogName), (Throwable)e);
        }
    }

    protected String getTruncateTableSql(TablePath tablePath) {
        throw new UnsupportedOperationException();
    }

    protected String getExistDataSql(TablePath tablePath) {
        throw new UnsupportedOperationException();
    }

    public void executeSql(TablePath tablePath, String sql) {
        String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
        Connection connection = this.getConnection(dbUrl);
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.execute();
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed executeSql error %s", sql), (Throwable)e);
        }
    }

    public boolean isExistsData(TablePath tablePath) {
        boolean bl;
        block8: {
            String dbUrl = this.getUrlFromDatabaseName(tablePath.getDatabaseName());
            Connection connection = this.getConnection(dbUrl);
            String sql = this.getExistDataSql(tablePath);
            PreparedStatement ps = connection.prepareStatement(sql);
            try {
                ResultSet resultSet = ps.executeQuery();
                bl = resultSet.next();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CatalogException(String.format("Failed executeSql error %s", sql), (Throwable)e);
                }
            }
            ps.close();
        }
        return bl;
    }

    public PreviewResult previewAction(Catalog.ActionType actionType, TablePath tablePath, Optional<CatalogTable> catalogTable) {
        if (actionType == Catalog.ActionType.CREATE_TABLE) {
            Preconditions.checkArgument(catalogTable.isPresent(), "CatalogTable cannot be null");
            return new SQLPreviewResult(this.getCreateTableSql(tablePath, catalogTable.get(), true));
        }
        if (actionType == Catalog.ActionType.DROP_TABLE) {
            return new SQLPreviewResult(this.getDropTableSql(tablePath));
        }
        if (actionType == Catalog.ActionType.TRUNCATE_TABLE) {
            return new SQLPreviewResult(this.getTruncateTableSql(tablePath));
        }
        if (actionType == Catalog.ActionType.CREATE_DATABASE) {
            return new SQLPreviewResult(this.getCreateDatabaseSql(tablePath.getDatabaseName()));
        }
        if (actionType == Catalog.ActionType.DROP_DATABASE) {
            return new SQLPreviewResult(this.getDropDatabaseSql(tablePath.getDatabaseName()));
        }
        throw new UnsupportedOperationException("Unsupported action type: " + actionType);
    }

    @FunctionalInterface
    public static interface ResultSetConsumer<T> {
        public T apply(ResultSet var1) throws SQLException;
    }
}

