/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class OracleTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(OracleTypeConverter.class);
    public static final String ORACLE_BINARY_DOUBLE = "BINARY_DOUBLE";
    public static final String ORACLE_BINARY_FLOAT = "BINARY_FLOAT";
    public static final String ORACLE_NUMBER = "NUMBER";
    public static final String ORACLE_FLOAT = "FLOAT";
    public static final String ORACLE_REAL = "REAL";
    public static final String ORACLE_INTEGER = "INTEGER";
    public static final String ORACLE_CHAR = "CHAR";
    public static final String ORACLE_NCHAR = "NCHAR";
    public static final String ORACLE_VARCHAR = "VARCHAR";
    public static final String ORACLE_VARCHAR2 = "VARCHAR2";
    public static final String ORACLE_NVARCHAR2 = "NVARCHAR2";
    public static final String ORACLE_LONG = "LONG";
    public static final String ORACLE_ROWID = "ROWID";
    public static final String ORACLE_CLOB = "CLOB";
    public static final String ORACLE_NCLOB = "NCLOB";
    public static final String ORACLE_XML = "XMLTYPE";
    public static final String ORACLE_SYS_XML = "SYS.XMLTYPE";
    public static final String ORACLE_DATE = "DATE";
    public static final String ORACLE_TIMESTAMP = "TIMESTAMP";
    public static final String ORACLE_TIMESTAMP_WITH_TIME_ZONE = "TIMESTAMP WITH TIME ZONE";
    public static final String ORACLE_TIMESTAMP_WITH_LOCAL_TIME_ZONE = "TIMESTAMP WITH LOCAL TIME ZONE";
    public static final String ORACLE_BLOB = "BLOB";
    public static final String ORACLE_RAW = "RAW";
    public static final String ORACLE_LONG_RAW = "LONG RAW";
    public static final int MAX_PRECISION = 38;
    public static final int DEFAULT_PRECISION = 38;
    public static final int MAX_SCALE = 127;
    public static final int DEFAULT_SCALE = 18;
    public static final int TIMESTAMP_DEFAULT_SCALE = 6;
    public static final int MAX_TIMESTAMP_SCALE = 9;
    public static final long MAX_RAW_LENGTH = 2000L;
    public static final long MAX_ROWID_LENGTH = 18L;
    public static final long MAX_CHAR_LENGTH = 2000L;
    public static final long MAX_VARCHAR_LENGTH = 4000L;
    public static final long BYTES_2GB = (long)Math.pow(2.0, 31.0);
    public static final long BYTES_4GB = (long)Math.pow(2.0, 32.0);
    public static final OracleTypeConverter INSTANCE = new OracleTypeConverter();

    public String identifier() {
        return "Oracle";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        String oracleType;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (oracleType = typeDefine.getDataType().toUpperCase()) {
            case "INTEGER": {
                builder.dataType((SeaTunnelDataType)new DecimalType(38, 0));
                builder.columnLength(Long.valueOf(38L));
                break;
            }
            case "NUMBER": {
                Integer scale;
                Long precision = typeDefine.getPrecision();
                if (precision == null || precision == 0L || precision > 38L) {
                    precision = 38L;
                }
                if ((scale = typeDefine.getScale()) == null) {
                    scale = 127;
                }
                if (scale <= 0) {
                    int newPrecision = (int)(precision - (long)scale.intValue());
                    if (newPrecision == 1) {
                        builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                        break;
                    }
                    if (newPrecision <= 9) {
                        builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                        break;
                    }
                    if (newPrecision <= 18) {
                        builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                        break;
                    }
                    if (newPrecision < 38) {
                        builder.dataType((SeaTunnelDataType)new DecimalType(newPrecision, 0));
                        builder.columnLength(Long.valueOf(newPrecision));
                        break;
                    }
                    builder.dataType((SeaTunnelDataType)new DecimalType(38, 0));
                    builder.columnLength(Long.valueOf(38L));
                    break;
                }
                if (scale <= 18) {
                    builder.dataType((SeaTunnelDataType)new DecimalType(precision.intValue(), scale.intValue()));
                    builder.columnLength(precision);
                    builder.scale(scale);
                    break;
                }
                builder.dataType((SeaTunnelDataType)new DecimalType(precision.intValue(), 18));
                builder.columnLength(precision);
                builder.scale(Integer.valueOf(18));
                break;
            }
            case "FLOAT": {
                DecimalType floatDecimal = new DecimalType(38, 18);
                builder.dataType((SeaTunnelDataType)floatDecimal);
                builder.columnLength(Long.valueOf(floatDecimal.getPrecision()));
                builder.scale(Integer.valueOf(floatDecimal.getScale()));
                break;
            }
            case "BINARY_FLOAT": 
            case "REAL": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "BINARY_DOUBLE": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "CHAR": 
            case "VARCHAR": 
            case "VARCHAR2": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "NCHAR": 
            case "NVARCHAR2": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(TypeDefineUtils.doubleByteTo4ByteLength(typeDefine.getLength()));
                break;
            }
            case "ROWID": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(18L));
                break;
            }
            case "XMLTYPE": 
            case "SYS.XMLTYPE": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "LONG": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(BYTES_2GB - 1L));
                break;
            }
            case "CLOB": 
            case "NCLOB": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(BYTES_4GB - 1L));
                break;
            }
            case "BLOB": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(BYTES_4GB - 1L));
                break;
            }
            case "RAW": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                if (typeDefine.getLength() == null || typeDefine.getLength() == 0L) {
                    builder.columnLength(Long.valueOf(2000L));
                    break;
                }
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "LONG RAW": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(BYTES_2GB - 1L));
                break;
            }
            case "DATE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                break;
            }
            case "TIMESTAMP": 
            case "TIMESTAMP WITH TIME ZONE": 
            case "TIMESTAMP WITH LOCAL TIME ZONE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                if (typeDefine.getScale() == null) {
                    builder.scale(Integer.valueOf(6));
                    break;
                }
                builder.scale(typeDefine.getScale());
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"Oracle", (String)oracleType, (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType(String.format("%s(%s)", ORACLE_NUMBER, 1));
                builder.dataType(ORACLE_NUMBER);
                builder.length(Long.valueOf(1L));
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                builder.columnType(ORACLE_INTEGER);
                builder.dataType(ORACLE_INTEGER);
                break;
            }
            case FLOAT: {
                builder.columnType(ORACLE_BINARY_FLOAT);
                builder.dataType(ORACLE_BINARY_FLOAT);
                break;
            }
            case DOUBLE: {
                builder.columnType(ORACLE_BINARY_DOUBLE);
                builder.dataType(ORACLE_BINARY_DOUBLE);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 38L;
                    scale = 18;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 38L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 38L));
                    precision = 38L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 38, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 127) {
                    scale = 127;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 127, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", ORACLE_NUMBER, precision, scale));
                builder.dataType(ORACLE_NUMBER);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case BYTES: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(ORACLE_BLOB);
                    builder.dataType(ORACLE_BLOB);
                    break;
                }
                if (column.getColumnLength() <= 2000L) {
                    builder.columnType(String.format("%s(%s)", ORACLE_RAW, column.getColumnLength()));
                    builder.dataType(ORACLE_RAW);
                    break;
                }
                builder.columnType(ORACLE_BLOB);
                builder.dataType(ORACLE_BLOB);
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(String.format("%s(%s)", ORACLE_VARCHAR2, 4000L));
                    builder.dataType(ORACLE_VARCHAR2);
                    break;
                }
                if (column.getColumnLength() <= 4000L) {
                    builder.columnType(String.format("%s(%s)", ORACLE_VARCHAR2, column.getColumnLength()));
                    builder.dataType(ORACLE_VARCHAR2);
                    break;
                }
                builder.columnType(ORACLE_CLOB);
                builder.dataType(ORACLE_CLOB);
                break;
            }
            case DATE: {
                builder.columnType(ORACLE_DATE);
                builder.dataType(ORACLE_DATE);
                break;
            }
            case TIMESTAMP: {
                if (column.getScale() == null || column.getScale() <= 0) {
                    builder.columnType(ORACLE_TIMESTAMP_WITH_LOCAL_TIME_ZONE);
                } else {
                    int timestampScale = column.getScale();
                    if (column.getScale() > 9) {
                        timestampScale = 9;
                        log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 9, timestampScale});
                    }
                    builder.columnType(String.format("TIMESTAMP(%s) WITH LOCAL TIME ZONE", timestampScale));
                    builder.scale(Integer.valueOf(timestampScale));
                }
                builder.dataType(ORACLE_TIMESTAMP_WITH_LOCAL_TIME_ZONE);
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"Oracle", (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

