/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

@Deprecated
public class JdbcColumnConverter {
    public static List<Column> convert(DatabaseMetaData metadata, TablePath tablePath) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        try (ResultSet columnsResultSet = metadata.getColumns(tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName(), null);){
            while (columnsResultSet.next()) {
                String columnName = columnsResultSet.getString("COLUMN_NAME");
                int jdbcType = columnsResultSet.getInt("DATA_TYPE");
                String nativeType = columnsResultSet.getString("TYPE_NAME");
                int columnSize = columnsResultSet.getInt("COLUMN_SIZE");
                int decimalDigits = columnsResultSet.getInt("DECIMAL_DIGITS");
                int nullable = columnsResultSet.getInt("NULLABLE");
                Column column = JdbcColumnConverter.convert(columnName, jdbcType, nativeType, nullable, columnSize, decimalDigits);
                columns.add(column);
            }
        }
        return columns;
    }

    public static Column convert(ResultSetMetaData metadata, int index) throws SQLException {
        String columnName = metadata.getColumnLabel(index);
        int jdbcType = metadata.getColumnType(index);
        String nativeType = metadata.getColumnTypeName(index);
        int isNullable = metadata.isNullable(index);
        int precision = metadata.getPrecision(index);
        int scale = metadata.getScale(index);
        return JdbcColumnConverter.convert(columnName, jdbcType, nativeType, isNullable, precision, scale);
    }

    public static Column convert(String columnName, int jdbcType, String nativeType, int isNullable, int precision, int scale) throws SQLException {
        BasicType seaTunnelType;
        int columnLength = precision;
        long longColumnLength = precision;
        long bitLength = 0L;
        switch (jdbcType) {
            case 16: {
                seaTunnelType = BasicType.BOOLEAN_TYPE;
                break;
            }
            case -7: {
                if (precision == 1) {
                    seaTunnelType = BasicType.BOOLEAN_TYPE;
                    break;
                }
                seaTunnelType = PrimitiveByteArrayType.INSTANCE;
                break;
            }
            case -6: {
                seaTunnelType = BasicType.BYTE_TYPE;
                break;
            }
            case 5: {
                seaTunnelType = BasicType.SHORT_TYPE;
                break;
            }
            case 4: {
                seaTunnelType = BasicType.INT_TYPE;
                break;
            }
            case -5: {
                seaTunnelType = BasicType.LONG_TYPE;
                break;
            }
            case 6: {
                seaTunnelType = BasicType.FLOAT_TYPE;
                break;
            }
            case 7: {
                seaTunnelType = BasicType.DOUBLE_TYPE;
                break;
            }
            case 8: {
                seaTunnelType = BasicType.DOUBLE_TYPE;
                break;
            }
            case 2: 
            case 3: {
                if (scale == 0) {
                    seaTunnelType = BasicType.LONG_TYPE;
                    break;
                }
                seaTunnelType = new DecimalType(precision, scale);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                seaTunnelType = BasicType.STRING_TYPE;
                columnLength = precision * 3;
                longColumnLength = precision * 3;
                break;
            }
            case 91: {
                seaTunnelType = LocalTimeType.LOCAL_DATE_TYPE;
                break;
            }
            case 92: 
            case 2013: {
                seaTunnelType = LocalTimeType.LOCAL_TIME_TYPE;
                break;
            }
            case 93: 
            case 2014: {
                seaTunnelType = LocalTimeType.LOCAL_DATE_TIME_TYPE;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                seaTunnelType = PrimitiveByteArrayType.INSTANCE;
                bitLength = precision * 8;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported JDBC type: " + jdbcType);
            }
        }
        return PhysicalColumn.of((String)columnName, (SeaTunnelDataType)seaTunnelType, (Integer)columnLength, (isNullable != 0 ? 1 : 0) != 0, null, null, (String)nativeType, (boolean)false, (boolean)false, (Long)bitLength, Collections.emptyMap(), (Long)longColumnLength);
    }
}

