/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import lombok.NonNull;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor.StatementFactory;

public class SimpleBatchStatementExecutor
implements JdbcBatchStatementExecutor<SeaTunnelRow> {
    @NonNull
    private final StatementFactory statementFactory;
    @NonNull
    private final TableSchema tableSchema;
    @NonNull
    private final JdbcRowConverter converter;
    private transient PreparedStatement statement;

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.statement = this.statementFactory.createStatement(connection);
    }

    @Override
    public void addToBatch(SeaTunnelRow record) throws SQLException {
        this.converter.toExternal(this.tableSchema, record, this.statement);
        this.statement.addBatch();
    }

    @Override
    public void executeBatch() throws SQLException {
        this.statement.executeBatch();
        this.statement.clearBatch();
    }

    @Override
    public void closeStatements() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
    }

    public SimpleBatchStatementExecutor(@NonNull StatementFactory statementFactory, @NonNull TableSchema tableSchema, @NonNull JdbcRowConverter converter) {
        if (statementFactory == null) {
            throw new NullPointerException("statementFactory is marked non-null but is null");
        }
        if (tableSchema == null) {
            throw new NullPointerException("tableSchema is marked non-null but is null");
        }
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        this.statementFactory = statementFactory;
        this.tableSchema = tableSchema;
        this.converter = converter;
    }
}

