/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.sink;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.sink.SinkCommonOptions;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcSink;

@AutoService(value={Factory.class})
public class JdbcSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Jdbc";
    }

    private ReadonlyConfig getCatalogOptions(TableSinkFactoryContext context) {
        ReadonlyConfig config = context.getOptions();
        Optional catalogOptions = config.getOptional(CatalogOptions.CATALOG_OPTIONS);
        if (catalogOptions.isPresent()) {
            return ReadonlyConfig.fromMap(new HashMap((Map)catalogOptions.get()));
        }
        return config;
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        String tempTableName;
        ReadonlyConfig config = context.getOptions();
        CatalogTable catalogTable = context.getCatalogTable();
        ReadonlyConfig catalogOptions = this.getCatalogOptions(context);
        Optional<String> optionalTable = config.getOptional(JdbcOptions.TABLE);
        Optional optionalDatabase = config.getOptional(JdbcOptions.DATABASE);
        if (!optionalTable.isPresent()) {
            optionalTable = Optional.of("${table_name}");
        }
        TableIdentifier tableId = catalogTable.getTableId();
        String sourceDatabaseName = tableId.getDatabaseName();
        String sourceSchemaName = tableId.getSchemaName();
        String sourceTableName = tableId.getTableName();
        String sinkDatabaseName = optionalDatabase.orElse("${database_name}");
        String sinkTableNameBefore = optionalTable.get();
        String[] sinkTableSplitArray = sinkTableNameBefore.split("\\.");
        String sinkTableName = sinkTableSplitArray[sinkTableSplitArray.length - 1];
        String sinkSchemaName = sinkTableSplitArray.length > 1 ? sinkTableSplitArray[sinkTableSplitArray.length - 2] : null;
        if (StringUtils.isNotBlank((CharSequence)catalogOptions.get(JdbcCatalogOptions.SCHEMA))) {
            sinkSchemaName = (String)catalogOptions.get(JdbcCatalogOptions.SCHEMA);
        }
        String prefix = (String)catalogOptions.get(JdbcCatalogOptions.TABLE_PREFIX);
        String suffix = (String)catalogOptions.get(JdbcCatalogOptions.TABLE_SUFFIX);
        if (StringUtils.isNotEmpty(prefix) || StringUtils.isNotEmpty(suffix)) {
            tempTableName = StringUtils.isNotEmpty(prefix) ? prefix + sinkTableName : sinkTableName;
            tempTableName = StringUtils.isNotEmpty(suffix) ? tempTableName + suffix : tempTableName;
        } else {
            tempTableName = sinkTableName;
        }
        String finalDatabaseName = sinkDatabaseName;
        if (StringUtils.isNotEmpty(sourceDatabaseName)) {
            finalDatabaseName = sinkDatabaseName.replace("${database_name}", sourceDatabaseName);
        }
        String finalSchemaName = sinkSchemaName != null ? (sourceSchemaName == null ? sinkSchemaName : sinkSchemaName.replace("${schema_name}", sourceSchemaName)) : null;
        String finalTableName = sinkTableName;
        if (StringUtils.isNotEmpty(sourceTableName)) {
            finalTableName = tempTableName.replace("${table_name}", sourceTableName);
        }
        TableIdentifier newTableId = TableIdentifier.of((String)tableId.getCatalogName(), (String)finalDatabaseName, (String)finalSchemaName, (String)finalTableName);
        catalogTable = CatalogTable.of((TableIdentifier)newTableId, (TableSchema)catalogTable.getTableSchema(), (Map)catalogTable.getOptions(), (List)catalogTable.getPartitionKeys(), (String)catalogTable.getComment(), (String)catalogTable.getCatalogName());
        Map map = config.toMap();
        if (catalogTable.getTableId().getSchemaName() != null) {
            map.put(JdbcOptions.TABLE.key(), catalogTable.getTableId().getSchemaName() + "." + catalogTable.getTableId().getTableName());
        } else {
            map.put(JdbcOptions.TABLE.key(), catalogTable.getTableId().getTableName());
        }
        map.put(JdbcOptions.DATABASE.key(), catalogTable.getTableId().getDatabaseName());
        PrimaryKey primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        if (!config.getOptional(JdbcOptions.PRIMARY_KEYS).isPresent()) {
            if (primaryKey != null && !CollectionUtils.isEmpty((Collection)primaryKey.getColumnNames())) {
                map.put(JdbcOptions.PRIMARY_KEYS.key(), String.join((CharSequence)",", primaryKey.getColumnNames()));
            } else {
                Optional<ConstraintKey> keyOptional = catalogTable.getTableSchema().getConstraintKeys().stream().filter(key -> ConstraintKey.ConstraintType.UNIQUE_KEY.equals((Object)key.getConstraintType())).findFirst();
                if (keyOptional.isPresent()) {
                    map.put(JdbcOptions.PRIMARY_KEYS.key(), keyOptional.get().getColumnNames().stream().map(key -> key.getColumnName()).collect(Collectors.joining(",")));
                }
            }
        } else {
            PrimaryKey configPk = PrimaryKey.of((String)(catalogTable.getTablePath().getTableName() + "_config_pk"), (List)((List)config.get(JdbcOptions.PRIMARY_KEYS)));
            TableSchema tableSchema = catalogTable.getTableSchema();
            catalogTable = CatalogTable.of((TableIdentifier)catalogTable.getTableId(), (TableSchema)TableSchema.builder().primaryKey(configPk).constraintKey(tableSchema.getConstraintKeys()).columns(tableSchema.getColumns()).build(), (Map)catalogTable.getOptions(), (List)catalogTable.getPartitionKeys(), (String)catalogTable.getComment(), (String)catalogTable.getCatalogName());
        }
        ReadonlyConfig options = config = ReadonlyConfig.fromMap(new HashMap(map));
        JdbcSinkConfig sinkConfig = JdbcSinkConfig.of(config);
        FieldIdeEnum fieldIdeEnum = (FieldIdeEnum)((Object)config.get(JdbcOptions.FIELD_IDE));
        catalogTable.getOptions().put("fieldIde", fieldIdeEnum == null ? null : fieldIdeEnum.getValue());
        JdbcDialect dialect = JdbcDialectLoader.load(sinkConfig.getJdbcConnectionConfig().getUrl(), sinkConfig.getJdbcConnectionConfig().getCompatibleMode(), fieldIdeEnum == null ? null : fieldIdeEnum.getValue());
        dialect.connectionUrlParse(sinkConfig.getJdbcConnectionConfig().getUrl(), sinkConfig.getJdbcConnectionConfig().getProperties(), dialect.defaultParameter());
        CatalogTable finalCatalogTable = catalogTable;
        DataSaveMode dataSaveMode = (DataSaveMode)config.get(JdbcOptions.DATA_SAVE_MODE);
        SchemaSaveMode schemaSaveMode = (SchemaSaveMode)config.get(JdbcOptions.SCHEMA_SAVE_MODE);
        return () -> new JdbcSink(options, sinkConfig, dialect, schemaSaveMode, dataSaveMode, finalCatalogTable);
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{JdbcOptions.URL, JdbcOptions.DRIVER, JdbcOptions.SCHEMA_SAVE_MODE, JdbcOptions.DATA_SAVE_MODE}).optional(new Option[]{JdbcCatalogOptions.CREATE_INDEX, JdbcOptions.USER, JdbcOptions.PASSWORD, JdbcOptions.CONNECTION_CHECK_TIMEOUT_SEC, JdbcOptions.BATCH_SIZE, JdbcOptions.IS_EXACTLY_ONCE, JdbcOptions.GENERATE_SINK_SQL, JdbcOptions.AUTO_COMMIT, JdbcOptions.SUPPORT_UPSERT_BY_QUERY_PRIMARY_KEY_EXIST, JdbcOptions.PRIMARY_KEYS, JdbcOptions.COMPATIBLE_MODE, SinkCommonOptions.MULTI_TABLE_SINK_REPLICA}).conditional(JdbcOptions.IS_EXACTLY_ONCE, (Object)true, new Option[]{JdbcOptions.XA_DATA_SOURCE_CLASS_NAME, JdbcOptions.MAX_COMMIT_ATTEMPTS, JdbcOptions.TRANSACTION_TIMEOUT_SEC}).conditional(JdbcOptions.IS_EXACTLY_ONCE, (Object)false, new Option[]{JdbcOptions.MAX_RETRIES}).conditional(JdbcOptions.GENERATE_SINK_SQL, (Object)true, new Option[]{JdbcOptions.DATABASE}).conditional(JdbcOptions.GENERATE_SINK_SQL, (Object)false, new Option[]{JdbcOptions.QUERY}).conditional(JdbcOptions.DATA_SAVE_MODE, (Object)DataSaveMode.CUSTOM_PROCESSING, new Option[]{JdbcOptions.CUSTOM_SQL}).build();
    }
}

