/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeTransactionsRequestData
implements ApiMessage {
    List<String> transactionalIds;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("transactional_ids", new CompactArrayOf(Type.COMPACT_STRING), "Array of transactionalIds to include in describe results. If empty, then no results will be returned."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeTransactionsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeTransactionsRequestData() {
        this.transactionalIds = new ArrayList<String>(0);
    }

    @Override
    public short apiKey() {
        return 65;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field transactionalIds was serialized as null");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field transactionalIds element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field transactionalIds element had invalid length " + length);
            }
            newCollection.add(_readable.readString(length));
        }
        this.transactionalIds = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.transactionalIds.size() + 1);
        for (String transactionalIdsElement : this.transactionalIds) {
            byte[] _stringBytes = _cache.getSerializedValue(transactionalIdsElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.transactionalIds.size() + 1));
        for (String transactionalIdsElement : this.transactionalIds) {
            byte[] _stringBytes = transactionalIdsElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'transactionalIdsElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(transactionalIdsElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeTransactionsRequestData)) {
            return false;
        }
        DescribeTransactionsRequestData other = (DescribeTransactionsRequestData)obj;
        if (this.transactionalIds == null ? other.transactionalIds != null : !this.transactionalIds.equals(other.transactionalIds)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalIds == null ? 0 : this.transactionalIds.hashCode());
        return hashCode;
    }

    @Override
    public DescribeTransactionsRequestData duplicate() {
        DescribeTransactionsRequestData _duplicate = new DescribeTransactionsRequestData();
        ArrayList<String> newTransactionalIds = new ArrayList<String>(this.transactionalIds.size());
        for (String _element : this.transactionalIds) {
            newTransactionalIds.add(_element);
        }
        _duplicate.transactionalIds = newTransactionalIds;
        return _duplicate;
    }

    public String toString() {
        return "DescribeTransactionsRequestData(transactionalIds=" + MessageUtil.deepToString(this.transactionalIds.iterator()) + ")";
    }

    public List<String> transactionalIds() {
        return this.transactionalIds;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeTransactionsRequestData setTransactionalIds(List<String> v) {
        this.transactionalIds = v;
        return this;
    }
}

