/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source;

import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.config.TiDBSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.config.TiDBSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.enumerator.TiDBSourceCheckpointState;
import org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.enumerator.TiDBSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.reader.TiDBSourceReader;
import org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.split.TiDBSourceSplit;

public class TiDBSource
implements SeaTunnelSource<SeaTunnelRow, TiDBSourceSplit, TiDBSourceCheckpointState>,
SupportParallelism,
SupportColumnProjection {
    static final String IDENTIFIER = "TiDB-CDC";
    private TiDBSourceConfig config;
    private final CatalogTable catalogTable;

    public TiDBSource(ReadonlyConfig config, CatalogTable catalogTable) {
        this.config = TiDBSourceConfig.builder().startupMode((StartupMode)((Object)config.get(TiDBSourceOptions.STARTUP_MODE))).databaseName((String)config.get(TiDBSourceOptions.DATABASE_NAME)).tableName((String)config.get(TiDBSourceOptions.TABLE_NAME)).batchSize((Integer)config.get(TiDBSourceOptions.BATCH_SIZE_PER_SCAN)).tiConfiguration(TiDBSourceOptions.getTiConfiguration(config)).build();
        this.catalogTable = catalogTable;
    }

    public String getPluginName() {
        return IDENTIFIER;
    }

    public Boundedness getBoundedness() {
        return Boundedness.UNBOUNDED;
    }

    public SourceReader<SeaTunnelRow, TiDBSourceSplit> createReader(SourceReader.Context context) throws Exception {
        return new TiDBSourceReader(context, this.config, this.catalogTable);
    }

    public SourceSplitEnumerator<TiDBSourceSplit, TiDBSourceCheckpointState> createEnumerator(SourceSplitEnumerator.Context<TiDBSourceSplit> context) throws Exception {
        return new TiDBSourceSplitEnumerator(context, this.config);
    }

    public SourceSplitEnumerator<TiDBSourceSplit, TiDBSourceCheckpointState> restoreEnumerator(SourceSplitEnumerator.Context<TiDBSourceSplit> context, TiDBSourceCheckpointState checkpointState) throws Exception {
        return new TiDBSourceSplitEnumerator(context, this.config, checkpointState);
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }
}

