/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.converter;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.cdc.debezium.utils.TemporalConversions;
import org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.converter.DataConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.types.DataType;

public class DefaultDataConverter
implements DataConverter<Object[]> {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataConverter.class);

    @Override
    public SeaTunnelRow convert(Object[] values, TiTableInfo tableInfo, SeaTunnelRowType rowType) throws Exception {
        Object[] fields = new Object[rowType.getTotalFields()];
        block17: for (int fieldIndex = 0; fieldIndex < rowType.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = rowType.getFieldType(fieldIndex);
            String fieldName = rowType.getFieldName(fieldIndex);
            TiColumnInfo columnInfo = tableInfo.getColumn(fieldName);
            if (columnInfo == null) {
                fields[fieldIndex] = null;
            }
            DataType dataType = columnInfo.getType();
            Object value = values[columnInfo.getOffset()];
            if (value == null) {
                fields[fieldIndex] = null;
                continue;
            }
            if (dataType.isUnsigned()) {
                value = DefaultDataConverter.rewriteUnsignedColumnValue(dataType, value);
            }
            switch (seaTunnelDataType.getSqlType()) {
                case NULL: {
                    fields[fieldIndex] = null;
                    continue block17;
                }
                case STRING: {
                    fields[fieldIndex] = DefaultDataConverter.convertToString(value);
                    continue block17;
                }
                case BOOLEAN: {
                    fields[fieldIndex] = DefaultDataConverter.convertToBoolean(value);
                    continue block17;
                }
                case TINYINT: {
                    fields[fieldIndex] = Byte.parseByte(value.toString());
                    continue block17;
                }
                case SMALLINT: {
                    fields[fieldIndex] = Short.parseShort(value.toString());
                    continue block17;
                }
                case INT: {
                    fields[fieldIndex] = DefaultDataConverter.convertToInt(value, dataType);
                    continue block17;
                }
                case BIGINT: {
                    fields[fieldIndex] = DefaultDataConverter.convertToLong(value);
                    continue block17;
                }
                case FLOAT: {
                    fields[fieldIndex] = DefaultDataConverter.convertToFloat(value);
                    continue block17;
                }
                case DOUBLE: {
                    fields[fieldIndex] = DefaultDataConverter.convertToDouble(value);
                    continue block17;
                }
                case DECIMAL: {
                    fields[fieldIndex] = DefaultDataConverter.createDecimalConverter(value);
                    continue block17;
                }
                case DATE: {
                    fields[fieldIndex] = DefaultDataConverter.convertToDate(value);
                    continue block17;
                }
                case TIME: {
                    fields[fieldIndex] = DefaultDataConverter.convertToTime(value);
                    continue block17;
                }
                case TIMESTAMP: {
                    fields[fieldIndex] = DefaultDataConverter.convertToTimestamp(value, dataType);
                    continue block17;
                }
                case BYTES: {
                    fields[fieldIndex] = DefaultDataConverter.convertToBinary(value);
                    continue block17;
                }
                case ARRAY: {
                    fields[fieldIndex] = this.convertToArray(value);
                    continue block17;
                }
                default: {
                    throw CommonError.unsupportedDataType((String)"SeaTunnel", (String)seaTunnelDataType.getSqlType().toString(), (String)fieldName);
                }
            }
        }
        return new SeaTunnelRow(fields);
    }

    public static Object rewriteUnsignedColumnValue(DataType dataType, Object object) {
        switch (dataType.getType()) {
            case TypeTiny: {
                return (short)Byte.toUnsignedInt(((Long)object).byteValue());
            }
            case TypeShort: {
                return Short.toUnsignedInt(((Long)object).shortValue());
            }
            case TypeInt24: {
                return ((Long)object).intValue() & 0xFFFFFF;
            }
            case TypeLong: {
                return Integer.toUnsignedLong(((Long)object).intValue());
            }
            case TypeLonglong: {
                return new BigDecimal(Long.toUnsignedString((Long)object));
            }
        }
        return object;
    }

    private static Object convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Long) {
            return (Long)value != 0L;
        }
        if (value instanceof Byte) {
            return (Byte)value != 0;
        }
        if (value instanceof byte[]) {
            Long result = DefaultDataConverter.bitToLong((byte[])value, 0, ((byte[])value).length);
            return result == -1L || result > 0L;
        }
        if (value instanceof Short) {
            return (Short)value != 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).shortValue() != 0;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private static Object convertToInt(Object value, DataType dataType) {
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Long) {
            return dataType.isUnsigned() ? Integer.valueOf(Short.toUnsignedInt(((Long)value).shortValue())).intValue() : ((Long)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    private static Object convertToLong(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return value;
        }
        return Long.parseLong(value.toString());
    }

    private static Object convertToDouble(Object value) {
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return value;
        }
        return Double.parseDouble(value.toString());
    }

    private static Object convertToFloat(Object value) {
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof Double) {
            return Float.valueOf(((Double)value).floatValue());
        }
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    private static Object createDecimalConverter(Object value) {
        BigDecimal result;
        if (value instanceof String) {
            result = new BigDecimal((String)value);
        } else if (value instanceof Long) {
            result = new BigDecimal(Long.parseLong(value.toString()));
        } else if (value instanceof Double) {
            result = BigDecimal.valueOf(Double.parseDouble(value.toString()));
        } else if (value instanceof BigDecimal) {
            result = (BigDecimal)value;
        } else {
            throw new IllegalArgumentException("Unable to convert to decimal from unexpected value '" + value + "' of type " + value.getClass());
        }
        return result;
    }

    public Object[] convertToArray(Object value) throws SQLException {
        Object[] array = ((String)value).split(",");
        if (array == null) {
            return null;
        }
        return array;
    }

    private static Object convertToBinary(Object value) {
        if (value instanceof byte[]) {
            return value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        if (value instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)value;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        throw new UnsupportedOperationException("Unsupported BYTES value type: " + value.getClass().getSimpleName());
    }

    private static Object convertToString(Object value) {
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value;
    }

    private static Object convertToDate(Object value) {
        return TemporalConversions.toLocalDate(value);
    }

    private static Object convertToTime(Object value) {
        if (value instanceof Long) {
            return LocalTime.ofNanoOfDay((Long)value);
        }
        return TemporalConversions.toLocalTime(value);
    }

    private static Object convertToTimestamp(Object value, DataType dataType) {
        switch (dataType.getType()) {
            case TypeTimestamp: {
                if (!(value instanceof Timestamp)) break;
                Instant instant = ((Timestamp)value).toInstant();
                long epochSecond = instant.getEpochSecond();
                int nanoSecond = instant.getNano();
                long millisecond = epochSecond * 1000L + (long)(nanoSecond / 1000000);
                int nanoOfMillisecond = nanoSecond % 1000000;
                return DefaultDataConverter.toLocalDateTime(millisecond, nanoOfMillisecond);
            }
            case TypeDatetime: {
                if (!(value instanceof Timestamp)) break;
                LocalDateTime dateTime = ((Timestamp)value).toLocalDateTime();
                long epochDay = dateTime.toLocalDate().toEpochDay();
                long nanoOfDay = dateTime.toLocalTime().toNanoOfDay();
                long millisecond = epochDay * 86400000L + nanoOfDay / 1000000L;
                int nanoOfMillisecond = (int)(nanoOfDay % 1000000L);
                return DefaultDataConverter.toLocalDateTime(millisecond, nanoOfMillisecond);
            }
            default: {
                throw new IllegalArgumentException("Unable to convert to LocalDateTime from unexpected value '" + value + "' of type " + value.getClass().getName());
            }
        }
        return value;
    }

    public static LocalDateTime toLocalDateTime(long millisecond, int nanoOfMillisecond) {
        int date = (int)(millisecond / 86400000L);
        int time = (int)(millisecond % 86400000L);
        if (time < 0) {
            --date;
            time += 86400000;
        }
        long nanoOfDay = (long)time * 1000000L + (long)nanoOfMillisecond;
        LocalDate localDate = LocalDate.ofEpochDay(date);
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
        return LocalDateTime.of(localDate, localTime);
    }

    public static long bitToLong(byte[] bytes, int offset, int length) {
        long valueAsLong = 0L;
        for (int i = 0; i < length; ++i) {
            valueAsLong = valueAsLong << 8 | (long)(bytes[offset + i] & 0xFF);
        }
        return valueAsLong;
    }
}

