/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.utils;

import java.math.BigInteger;
import java.util.List;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.com.google.common.collect.ImmutableList;
import org.tikv.common.key.RowKey;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.kvproto.Coprocessor;

public class TableKeyRangeUtils {
    public static Coprocessor.KeyRange getTableKeyRange(long tableId) {
        return KeyRangeUtils.makeCoprocRange(RowKey.createMin(tableId).toByteString(), RowKey.createBeyondMax(tableId).toByteString());
    }

    public static List<Coprocessor.KeyRange> getTableKeyRanges(long tableId, int num) {
        Preconditions.checkArgument((num > 0 ? 1 : 0) != 0, (Object)"Illegal value of num");
        if (num == 1) {
            return ImmutableList.of((Object)TableKeyRangeUtils.getTableKeyRange(tableId));
        }
        long delta = BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.valueOf(-9223372036854775807L)).divide(BigInteger.valueOf(num)).longValueExact();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < num; ++i) {
            RowKey startKey = i == 0 ? RowKey.createMin(tableId) : RowKey.toRowKey(tableId, Long.MIN_VALUE + delta * (long)i);
            RowKey endKey = i == num - 1 ? RowKey.createBeyondMax(tableId) : RowKey.toRowKey(tableId, Long.MIN_VALUE + delta * (long)(i + 1));
            builder.add((Object)KeyRangeUtils.makeCoprocRange(startKey.toByteString(), endKey.toByteString()));
        }
        return builder.build();
    }

    public static boolean isRecordKey(byte[] key) {
        return key[9] == 95 && key[10] == 114;
    }
}

