/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.dm;

import com.google.auto.service.AutoService;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.dm.DamengCatalog;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

@AutoService(value={Factory.class})
public class DamengCatalogFactory
implements CatalogFactory {
    public String factoryIdentifier() {
        return "Dameng";
    }

    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        String urlWithDatabase = (String)options.get(JdbcCatalogOptions.BASE_URL);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank(urlWithDatabase), (Object)"Miss config <base-url>! Please check your config.");
        JdbcUrlUtil.UrlInfo urlInfo = JdbcUrlUtil.getUrlInfo((String)urlWithDatabase);
        return new DamengCatalog(catalogName, (String)options.get(JdbcCatalogOptions.USERNAME), (String)options.get(JdbcCatalogOptions.PASSWORD), urlInfo, (String)options.get(JdbcCatalogOptions.SCHEMA));
    }

    public OptionRule optionRule() {
        return JdbcCatalogOptions.BASE_RULE.build();
    }
}

