/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.config;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.tikv.common.TiConfiguration;

public class TiDBSourceOptions
implements Serializable {
    public static final Option<String> DATABASE_NAME = Options.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the TiDB server to monitor.");
    public static final Option<String> TABLE_NAME = Options.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the database to monitor.");
    public static final Option<StartupMode> STARTUP_MODE = Options.key((String)"startup.mode").singleChoice(StartupMode.class, Arrays.asList(StartupMode.INITIAL, StartupMode.EARLIEST, StartupMode.LATEST)).defaultValue((Object)StartupMode.INITIAL).withDescription("Optional startup mode for CDC source, valid enumerations are \"initial\", \"earliest\", \"latest\"");
    public static final Option<String> PD_ADDRESSES = Options.key((String)"pd-addresses").stringType().noDefaultValue().withDescription("TiKV cluster's PD address");
    public static final Option<Integer> BATCH_SIZE_PER_SCAN = Options.key((String)"batch-size-per-sca ").intType().defaultValue((Object)1000).withDescription("Size per scan");
    public static final Option<Long> TIKV_GRPC_TIMEOUT = Options.key((String)"tikv.grpc.timeout_in_ms").longType().noDefaultValue().withDescription("TiKV GRPC timeout in ms");
    public static final Option<Long> TIKV_GRPC_SCAN_TIMEOUT = Options.key((String)"tikv.grpc.scan_timeout_in_ms").longType().noDefaultValue().withDescription("TiKV GRPC scan timeout in ms");
    public static final Option<Integer> TIKV_BATCH_GET_CONCURRENCY = Options.key((String)"tikv.batch_get_concurrency").intType().noDefaultValue().withDescription("TiKV GRPC batch get concurrency");
    public static final Option<Integer> TIKV_BATCH_SCAN_CONCURRENCY = Options.key((String)"tikv.batch_scan_concurrency").intType().noDefaultValue().withDescription("TiKV GRPC batch scan concurrency");

    public static TiConfiguration getTiConfiguration(ReadonlyConfig configuration) {
        String pdAddrsStr = (String)configuration.get(PD_ADDRESSES);
        TiConfiguration tiConf = TiConfiguration.createDefault(pdAddrsStr);
        configuration.getOptional(TIKV_GRPC_TIMEOUT).ifPresent(tiConf::setTimeout);
        configuration.getOptional(TIKV_GRPC_SCAN_TIMEOUT).ifPresent(tiConf::setScanTimeout);
        configuration.getOptional(TIKV_BATCH_GET_CONCURRENCY).ifPresent(tiConf::setBatchGetConcurrency);
        configuration.getOptional(TIKV_BATCH_SCAN_CONCURRENCY).ifPresent(tiConf::setBatchScanConcurrency);
        return tiConf;
    }
}

