/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.reader;

import java.util.Objects;
import org.tikv.common.key.RowKey;
import org.tikv.kvproto.Cdcpb;

public class RowKeyWithTs
implements Comparable<RowKeyWithTs> {
    private final long timestamp;
    private final RowKey rowKey;

    private RowKeyWithTs(long timestamp, RowKey rowKey) {
        this.timestamp = timestamp;
        this.rowKey = rowKey;
    }

    private RowKeyWithTs(long timestamp, byte[] key) {
        this(timestamp, RowKey.decode(key));
    }

    @Override
    public int compareTo(RowKeyWithTs that) {
        int res = Long.compare(this.timestamp, that.timestamp);
        if (res == 0) {
            res = Long.compare(this.rowKey.getTableId(), that.rowKey.getTableId());
        }
        if (res == 0) {
            res = Long.compare(this.rowKey.getHandle(), that.rowKey.getHandle());
        }
        return res;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.rowKey.getTableId(), this.rowKey.getHandle());
    }

    public boolean equals(Object thatObj) {
        if (thatObj instanceof RowKeyWithTs) {
            RowKeyWithTs that = (RowKeyWithTs)thatObj;
            return this.timestamp == that.timestamp && this.rowKey.equals(that.rowKey);
        }
        return false;
    }

    static RowKeyWithTs ofStart(Cdcpb.Event.Row row) {
        return new RowKeyWithTs(row.getStartTs(), row.getKey().toByteArray());
    }

    static RowKeyWithTs ofCommit(Cdcpb.Event.Row row) {
        return new RowKeyWithTs(row.getCommitTs(), row.getKey().toByteArray());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public RowKey getRowKey() {
        return this.rowKey;
    }

    public String toString() {
        return "RowKeyWithTs(timestamp=" + this.getTimestamp() + ", rowKey=" + this.getRowKey() + ")";
    }
}

