/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.tidb.source.split;

import org.apache.seatunnel.api.source.SourceSplit;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.protobuf.ByteString;

public class TiDBSourceSplit
implements SourceSplit {
    private static final long serialVersionUID = -9043797960947110643L;
    private String database;
    private String table;
    private Coprocessor.KeyRange keyRange;
    private long resolvedTs;
    private ByteString snapshotStart;
    private boolean snapshotCompleted;

    public String splitId() {
        return String.format("%s:%s:%s-%s", this.database, this.table, this.keyRange.getStart(), this.keyRange.getEnd());
    }

    public String toString() {
        return String.format("TiDBSourceSplit: %s.%s,start=%s,end=%s", this.getDatabase(), this.getTable(), this.getKeyRange().getStart(), this.getKeyRange().getEnd());
    }

    public TiDBSourceSplit(String database, String table, Coprocessor.KeyRange keyRange, long resolvedTs, ByteString snapshotStart, boolean snapshotCompleted) {
        this.database = database;
        this.table = table;
        this.keyRange = keyRange;
        this.resolvedTs = resolvedTs;
        this.snapshotStart = snapshotStart;
        this.snapshotCompleted = snapshotCompleted;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public Coprocessor.KeyRange getKeyRange() {
        return this.keyRange;
    }

    public long getResolvedTs() {
        return this.resolvedTs;
    }

    public ByteString getSnapshotStart() {
        return this.snapshotStart;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setKeyRange(Coprocessor.KeyRange keyRange) {
        this.keyRange = keyRange;
    }

    public void setResolvedTs(long resolvedTs) {
        this.resolvedTs = resolvedTs;
    }

    public void setSnapshotStart(ByteString snapshotStart) {
        this.snapshotStart = snapshotStart;
    }

    public void setSnapshotCompleted(boolean snapshotCompleted) {
        this.snapshotCompleted = snapshotCompleted;
    }
}

