/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file;

import com.clickhouse.client.ClickHouseNode;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseFileCopyMethod;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseFileSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.FileReaderOption;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.NodePassConfig;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.Shard;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.ShardMetadata;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.ClickhouseFileSink;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.ClickhouseTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseProxy;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseUtil;

@AutoService(value={Factory.class})
public class ClickhouseFileSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "ClickhouseFile";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{ClickhouseBaseOptions.HOST, ClickhouseSinkOptions.TABLE, ClickhouseBaseOptions.DATABASE, ClickhouseBaseOptions.USERNAME, ClickhouseBaseOptions.PASSWORD, ClickhouseFileSinkOptions.CLICKHOUSE_LOCAL_PATH}).optional(new Option[]{ClickhouseFileSinkOptions.COPY_METHOD, ClickhouseSinkOptions.SHARDING_KEY, ClickhouseFileSinkOptions.NODE_FREE_PASSWORD, ClickhouseFileSinkOptions.NODE_PASS, ClickhouseFileSinkOptions.COMPATIBLE_MODE, ClickhouseFileSinkOptions.FILE_FIELDS_DELIMITER, ClickhouseFileSinkOptions.FILE_TEMP_PATH, ClickhouseFileSinkOptions.KEY_PATH, ClickhouseBaseOptions.SERVER_TIME_ZONE}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        ReadonlyConfig readonlyConfig = context.getOptions();
        CatalogTable catalogTable = context.getCatalogTable();
        List<ClickHouseNode> nodes = ClickhouseUtil.createNodes((String)readonlyConfig.get(ClickhouseBaseOptions.HOST), (String)readonlyConfig.get(ClickhouseBaseOptions.DATABASE), (String)readonlyConfig.get(ClickhouseBaseOptions.SERVER_TIME_ZONE), (String)readonlyConfig.get(ClickhouseBaseOptions.USERNAME), (String)readonlyConfig.get(ClickhouseBaseOptions.PASSWORD), null);
        ClickhouseProxy proxy = new ClickhouseProxy(nodes.get(0));
        Map<String, String> tableSchema = proxy.getClickhouseTableSchema((String)readonlyConfig.get(ClickhouseSinkOptions.TABLE));
        ClickhouseTable table = proxy.getClickhouseTable(proxy.getClickhouseConnection(), (String)readonlyConfig.get(ClickhouseBaseOptions.DATABASE), (String)readonlyConfig.get(ClickhouseSinkOptions.TABLE));
        String shardKey = null;
        String shardKeyType = null;
        if (readonlyConfig.getOptional(ClickhouseSinkOptions.SHARDING_KEY).isPresent()) {
            shardKey = (String)readonlyConfig.getOptional(ClickhouseSinkOptions.SHARDING_KEY).get();
            shardKeyType = tableSchema.get(shardKey);
        }
        ShardMetadata shardMetadata = new ShardMetadata(shardKey, shardKeyType, (String)readonlyConfig.get(ClickhouseBaseOptions.DATABASE), (String)readonlyConfig.get(ClickhouseSinkOptions.TABLE), table.getEngine(), true, new Shard(1, 1, nodes.get(0)), (String)readonlyConfig.get(ClickhouseBaseOptions.USERNAME), (String)readonlyConfig.get(ClickhouseBaseOptions.PASSWORD));
        ArrayList<String> fields = new ArrayList<String>(tableSchema.keySet());
        Map<String, String> nodeUser = readonlyConfig.toConfig().getObjectList(ClickhouseFileSinkOptions.NODE_PASS.key()).stream().collect(Collectors.toMap(configObject -> configObject.toConfig().getString("node_address"), configObject -> configObject.toConfig().hasPath(ClickhouseBaseOptions.USERNAME.key()) ? configObject.toConfig().getString(ClickhouseBaseOptions.USERNAME.key()) : "root"));
        Map<String, String> nodePassword = ((List)readonlyConfig.get(ClickhouseFileSinkOptions.NODE_PASS)).stream().collect(Collectors.toMap(NodePassConfig::getNodeAddress, NodePassConfig::getPassword));
        proxy.close();
        if (((String)readonlyConfig.get(ClickhouseFileSinkOptions.FILE_FIELDS_DELIMITER)).length() != 1) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, ClickhouseFileSinkOptions.FILE_FIELDS_DELIMITER.key() + " must be a single character");
        }
        FileReaderOption readerOption = new FileReaderOption(shardMetadata, tableSchema, fields, (String)readonlyConfig.get(ClickhouseFileSinkOptions.CLICKHOUSE_LOCAL_PATH), ClickhouseFileCopyMethod.from(((ClickhouseFileCopyMethod)((Object)readonlyConfig.get(ClickhouseFileSinkOptions.COPY_METHOD))).getName()), nodeUser, (Boolean)readonlyConfig.get(ClickhouseFileSinkOptions.NODE_FREE_PASSWORD), nodePassword, (Boolean)readonlyConfig.get(ClickhouseFileSinkOptions.COMPATIBLE_MODE), (String)readonlyConfig.get(ClickhouseFileSinkOptions.FILE_TEMP_PATH), (String)readonlyConfig.get(ClickhouseFileSinkOptions.FILE_FIELDS_DELIMITER), (String)readonlyConfig.get(ClickhouseFileSinkOptions.KEY_PATH));
        readerOption.setSeaTunnelRowType(catalogTable.getSeaTunnelRowType());
        return () -> new ClickhouseFileSink(readerOption);
    }
}

