/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.source;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhouseSource;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseUtil;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.TypeConvertUtil;

@AutoService(value={Factory.class})
public class ClickhouseSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Clickhouse";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        ReadonlyConfig readonlyConfig = context.getOptions();
        List<ClickHouseNode> nodes = ClickhouseUtil.createNodes(readonlyConfig);
        String sql = (String)readonlyConfig.get(ClickhouseSourceOptions.SQL);
        ClickHouseNode currentServer = nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
        try (ClickHouseClient client = ClickHouseClient.newInstance(currentServer.getProtocol());){
            ClickHouseResponse response = ((ClickHouseRequest)((ClickHouseRequest)client.connect(currentServer).format(ClickHouseFormat.RowBinaryWithNamesAndTypes)).query(this.modifySQLToLimit1(sql))).executeAndWait();
            try {
                TableSchema.Builder builder = TableSchema.builder();
                List<ClickHouseColumn> columns = response.getColumns();
                columns.forEach(column -> {
                    PhysicalColumn physicalColumn = PhysicalColumn.of((String)column.getColumnName(), TypeConvertUtil.convert(column), (Long)Long.valueOf(column.getEstimatedLength()), (Integer)column.getScale(), (boolean)column.isNullable(), null, null);
                    builder.column((Column)physicalColumn);
                });
                String catalogName = "clickhouse_catalog";
                CatalogTable catalogTable = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)catalogName, (String)((String)readonlyConfig.get(ClickhouseBaseOptions.DATABASE)), (String)"default"), (TableSchema)builder.build(), Collections.emptyMap(), Collections.emptyList(), (String)"", (String)catalogName);
                TableSource tableSource = () -> new ClickhouseSource(nodes, catalogTable, sql);
                if (response != null) {
                    response.close();
                }
                return tableSource;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (ClickHouseException e) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.factoryIdentifier(), PluginType.SOURCE, e.getMessage()));
        }
    }

    private String modifySQLToLimit1(String sql) {
        return String.format("SELECT * FROM (%s) s LIMIT 1", sql);
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{ClickhouseBaseOptions.HOST, ClickhouseBaseOptions.DATABASE, ClickhouseSourceOptions.SQL, ClickhouseBaseOptions.USERNAME, ClickhouseBaseOptions.PASSWORD}).optional(new Option[]{ClickhouseBaseOptions.CLICKHOUSE_CONFIG, ClickhouseBaseOptions.SERVER_TIME_ZONE}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return ClickhouseSource.class;
    }
}

