/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.util;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;

public class TypeConvertUtil {
    public static SeaTunnelDataType<?> convert(ClickHouseColumn column) {
        if (column.isArray()) {
            ClickHouseColumn subArrayDataType = column.getNestedColumns().get(0);
            SeaTunnelDataType<?> dataType = TypeConvertUtil.convert(subArrayDataType);
            if (BasicType.INT_TYPE.equals(dataType)) {
                return ArrayType.INT_ARRAY_TYPE;
            }
            if (BasicType.STRING_TYPE.equals(dataType)) {
                return ArrayType.STRING_ARRAY_TYPE;
            }
            if (BasicType.FLOAT_TYPE.equals(dataType)) {
                return ArrayType.FLOAT_ARRAY_TYPE;
            }
            if (BasicType.DOUBLE_TYPE.equals(dataType)) {
                return ArrayType.DOUBLE_ARRAY_TYPE;
            }
            if (BasicType.LONG_TYPE.equals(dataType)) {
                return ArrayType.LONG_ARRAY_TYPE;
            }
            if (BasicType.SHORT_TYPE.equals(dataType)) {
                return ArrayType.SHORT_ARRAY_TYPE;
            }
            if (BasicType.BOOLEAN_TYPE.equals(dataType)) {
                return ArrayType.BOOLEAN_ARRAY_TYPE;
            }
            if (BasicType.BYTE_TYPE.equals(dataType)) {
                return ArrayType.BYTE_ARRAY_TYPE;
            }
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "data type in array is not supported: " + (Object)((Object)subArrayDataType.getDataType()));
        }
        Class<?> type = column.getDataType().getObjectClass();
        if (Integer.class.equals(type)) {
            return BasicType.INT_TYPE;
        }
        if (Long.class.equals(type)) {
            return BasicType.LONG_TYPE;
        }
        if (Short.class.equals(type)) {
            return BasicType.SHORT_TYPE;
        }
        if (Byte.class.equals(type)) {
            return BasicType.BYTE_TYPE;
        }
        if (Boolean.class.equals(type)) {
            return BasicType.BOOLEAN_TYPE;
        }
        if (LocalDate.class.equals(type)) {
            return LocalTimeType.LOCAL_DATE_TYPE;
        }
        if (LocalDateTime.class.equals(type)) {
            return LocalTimeType.LOCAL_DATE_TIME_TYPE;
        }
        if (BigDecimal.class.equals(type)) {
            return new DecimalType(column.getPrecision(), column.getScale());
        }
        if (String.class.equals(type)) {
            return BasicType.STRING_TYPE;
        }
        if (Float.class.equals(type)) {
            return BasicType.FLOAT_TYPE;
        }
        if (Double.class.equals(type)) {
            return BasicType.DOUBLE_TYPE;
        }
        if (Map.class.equals(type)) {
            return new MapType(TypeConvertUtil.convert(column.getNestedColumns().get(0)), TypeConvertUtil.convert(column.getNestedColumns().get(1)));
        }
        if (UUID.class.equals(type)) {
            return BasicType.STRING_TYPE;
        }
        if (Inet4Address.class.equals(type)) {
            return BasicType.STRING_TYPE;
        }
        if (Inet6Address.class.equals(type)) {
            return BasicType.STRING_TYPE;
        }
        if (Object.class.equals(type)) {
            return BasicType.STRING_TYPE;
        }
        if (BigInteger.class.equals(type)) {
            return BasicType.STRING_TYPE;
        }
        throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "unsupported data type: " + (Object)((Object)column.getDataType()));
    }

    public static Object valueUnwrap(SeaTunnelDataType<?> dataType, ClickHouseValue record) {
        if (dataType instanceof DecimalType) {
            return record.asBigDecimal();
        }
        if (dataType.equals((Object)BasicType.BOOLEAN_TYPE)) {
            return record.asBoolean();
        }
        if (dataType.equals((Object)BasicType.INT_TYPE)) {
            return record.asInteger();
        }
        if (dataType.equals((Object)BasicType.LONG_TYPE)) {
            return record.asLong();
        }
        if (dataType.equals((Object)BasicType.SHORT_TYPE)) {
            return record.asShort();
        }
        if (dataType.equals((Object)BasicType.BYTE_TYPE)) {
            return record.asByte();
        }
        if (dataType.equals((Object)LocalTimeType.LOCAL_DATE_TYPE)) {
            return record.asDate();
        }
        if (dataType.equals((Object)LocalTimeType.LOCAL_DATE_TIME_TYPE)) {
            return record.asDateTime();
        }
        if (dataType.equals((Object)BasicType.STRING_TYPE)) {
            return record.asString();
        }
        if (dataType.equals((Object)BasicType.FLOAT_TYPE)) {
            return Float.valueOf(record.asFloat());
        }
        if (dataType.equals((Object)BasicType.DOUBLE_TYPE)) {
            return record.asDouble();
        }
        if (dataType instanceof MapType) {
            return record.asMap();
        }
        if (dataType instanceof ArrayType) {
            Class typeClass = dataType.getTypeClass();
            if (String[].class.equals((Object)typeClass)) {
                return record.asArray(String.class);
            }
            if (Boolean[].class.equals((Object)typeClass)) {
                return record.asArray(Boolean.class);
            }
            if (Byte[].class.equals((Object)typeClass)) {
                return record.asArray(Byte.class);
            }
            if (Short[].class.equals((Object)typeClass)) {
                return record.asArray(Short.class);
            }
            if (Integer[].class.equals((Object)typeClass)) {
                return record.asArray(Integer.class);
            }
            if (Long[].class.equals((Object)typeClass)) {
                return record.asArray(Long.class);
            }
            if (Float[].class.equals((Object)typeClass)) {
                return record.asArray(Float.class);
            }
            if (Double[].class.equals((Object)typeClass)) {
                return record.asArray(Double.class);
            }
            return record.asArray();
        }
        throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "unsupported data type: " + dataType);
    }
}

