/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.catalog;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PreviewResult;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.SQLPreviewResult;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseCatalogUtil;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseProxy;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseUtil;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.TypeConvertUtil;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickhouseCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseCatalog.class);
    protected String defaultDatabase = "information_schema";
    private ReadonlyConfig readonlyConfig;
    private ClickhouseProxy proxy;
    private final String template;
    private String catalogName;

    public ClickhouseCatalog(ReadonlyConfig readonlyConfig, String catalogName) {
        this.readonlyConfig = readonlyConfig;
        this.catalogName = catalogName;
        this.template = (String)readonlyConfig.get(ClickhouseSinkOptions.SAVE_MODE_CREATE_TEMPLATE);
    }

    public List<String> listDatabases() throws CatalogException {
        return this.proxy.listDatabases();
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        return this.proxy.listTable(databaseName);
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        List<ClickHouseColumn> clickHouseColumns = this.proxy.getClickHouseColumns(tablePath.getFullNameWithQuoted());
        try {
            Optional<PrimaryKey> primaryKey = this.proxy.getPrimaryKey(tablePath.getDatabaseName(), tablePath.getTableName());
            TableSchema.Builder builder = TableSchema.builder();
            primaryKey.ifPresent(arg_0 -> ((TableSchema.Builder)builder).primaryKey(arg_0));
            this.buildColumnsWithErrorCheck(tablePath, builder, clickHouseColumns.iterator(), column -> PhysicalColumn.of((String)column.getColumnName(), TypeConvertUtil.convert(column), (Long)Long.valueOf(column.getEstimatedLength()), (Integer)column.getScale(), (boolean)column.isNullable(), null, null));
            TableIdentifier tableIdentifier = TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName());
            return CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)builder.build(), this.buildConnectorOptions(tablePath), Collections.emptyList(), (String)"");
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        log.debug("Create table :{}.{}", (Object)tablePath.getDatabaseName(), (Object)tablePath.getTableName());
        this.proxy.createTable(tablePath.getDatabaseName(), tablePath.getTableName(), this.template, table.getComment(), table.getTableSchema());
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.proxy.dropTable(tablePath, ignoreIfNotExists);
    }

    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            if (this.tableExists(tablePath)) {
                this.proxy.truncateTable(tablePath, ignoreIfNotExists);
            }
        }
        catch (Exception e) {
            throw new CatalogException("Truncate table failed", (Throwable)e);
        }
    }

    public void executeSql(TablePath tablePath, String sql) {
        try {
            this.proxy.executeSql(sql);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed EXECUTE SQL in catalog %s", sql), (Throwable)e);
        }
    }

    public boolean isExistsData(TablePath tablePath) {
        try {
            return this.proxy.isExistsData(tablePath.getFullName());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        this.proxy.createDatabase(tablePath.getDatabaseName(), ignoreIfExists);
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        this.proxy.dropDatabase(tablePath.getDatabaseName(), ignoreIfNotExists);
    }

    private Map<String, String> buildConnectorOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>(8);
        options.put("connector", "clickhouse");
        options.put("host", (String)this.readonlyConfig.get(ClickhouseBaseOptions.HOST));
        options.put("database", tablePath.getDatabaseName());
        return options;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void open() throws CatalogException {
        List<ClickHouseNode> nodes = ClickhouseUtil.createNodes(this.readonlyConfig);
        Properties clickhouseProperties = new Properties();
        ((Map)this.readonlyConfig.get(ClickhouseBaseOptions.CLICKHOUSE_CONFIG)).forEach((key, value) -> clickhouseProperties.put(key, String.valueOf(value)));
        clickhouseProperties.put("user", this.readonlyConfig.get(ClickhouseBaseOptions.USERNAME));
        clickhouseProperties.put("password", this.readonlyConfig.get(ClickhouseBaseOptions.PASSWORD));
        this.proxy = new ClickhouseProxy(nodes.get(0));
    }

    public void close() throws CatalogException {
    }

    public String name() {
        return this.catalogName;
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(databaseName));
        return this.listDatabases().contains(databaseName);
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        return this.proxy.tableExists(tablePath.getDatabaseName(), tablePath.getTableName());
    }

    public PreviewResult previewAction(Catalog.ActionType actionType, TablePath tablePath, Optional<CatalogTable> catalogTable) {
        if (actionType == Catalog.ActionType.CREATE_TABLE) {
            Preconditions.checkArgument((boolean)catalogTable.isPresent(), (Object)"CatalogTable cannot be null");
            return new SQLPreviewResult(ClickhouseCatalogUtil.INSTANCE.getCreateTableSql(this.template, tablePath.getDatabaseName(), tablePath.getTableName(), catalogTable.get().getTableSchema(), catalogTable.get().getComment(), ClickhouseSinkOptions.SAVE_MODE_CREATE_TEMPLATE.key()));
        }
        if (actionType == Catalog.ActionType.DROP_TABLE) {
            return new SQLPreviewResult(ClickhouseCatalogUtil.INSTANCE.getDropTableSql(tablePath, true));
        }
        if (actionType == Catalog.ActionType.TRUNCATE_TABLE) {
            return new SQLPreviewResult(ClickhouseCatalogUtil.INSTANCE.getTruncateTableSql(tablePath));
        }
        if (actionType == Catalog.ActionType.CREATE_DATABASE) {
            return new SQLPreviewResult(ClickhouseCatalogUtil.INSTANCE.getCreateDatabaseSql(tablePath.getDatabaseName(), true));
        }
        if (actionType == Catalog.ActionType.DROP_DATABASE) {
            return new SQLPreviewResult(ClickhouseCatalogUtil.INSTANCE.getDropDatabaseSql(tablePath.getDatabaseName(), true));
        }
        throw new UnsupportedOperationException("Unsupported action type: " + actionType);
    }
}

