/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file;

import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.FileReaderOption;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.Shard;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.ClickhouseTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.CKFileAggCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.CKFileCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickhouseFileSinkAggCommitter
implements SinkAggregatedCommitter<CKFileCommitInfo, CKFileAggCommitInfo> {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseFileSinkAggCommitter.class);
    private transient ClickhouseProxy proxy;
    private ClickhouseTable clickhouseTable;
    private final FileReaderOption fileReaderOption;

    public ClickhouseFileSinkAggCommitter(FileReaderOption readerOption) {
        this.fileReaderOption = readerOption;
    }

    public void init() {
        this.proxy = new ClickhouseProxy(this.fileReaderOption.getShardMetadata().getDefaultShard().getNode());
        this.clickhouseTable = this.proxy.getClickhouseTable(this.proxy.getClickhouseConnection(), this.fileReaderOption.getShardMetadata().getDatabase(), this.fileReaderOption.getShardMetadata().getTable());
    }

    public List<CKFileAggCommitInfo> commit(List<CKFileAggCommitInfo> aggregatedCommitInfo) throws IOException {
        aggregatedCommitInfo.forEach(commitInfo -> commitInfo.getDetachedFiles().forEach((shard, files) -> {
            try {
                this.attachFileToClickhouse((Shard)shard, (List<String>)files);
            }
            catch (ClickHouseException e) {
                throw new SeaTunnelException("failed commit file to clickhouse", (Throwable)e);
            }
        }));
        return new ArrayList<CKFileAggCommitInfo>();
    }

    public CKFileAggCommitInfo combine(List<CKFileCommitInfo> commitInfos) {
        HashMap<Shard, List<String>> files = new HashMap<Shard, List<String>>();
        commitInfos.forEach(infos -> infos.getDetachedFiles().forEach((shard, file) -> {
            if (files.containsKey(shard)) {
                ((List)files.get(shard)).addAll(file);
            } else {
                files.put((Shard)shard, (List<String>)file);
            }
        }));
        return new CKFileAggCommitInfo(files);
    }

    public void abort(List<CKFileAggCommitInfo> aggregatedCommitInfo) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClickhouseProxy getProxy() {
        if (this.proxy != null) {
            return this.proxy;
        }
        ClickhouseFileSinkAggCommitter clickhouseFileSinkAggCommitter = this;
        synchronized (clickhouseFileSinkAggCommitter) {
            if (this.proxy != null) {
                return this.proxy;
            }
            this.proxy = new ClickhouseProxy(this.fileReaderOption.getShardMetadata().getDefaultShard().getNode());
            return this.proxy;
        }
    }

    public void close() throws IOException {
        if (this.proxy != null) {
            this.proxy.close();
        }
    }

    private void attachFileToClickhouse(Shard shard, List<String> clickhouseLocalFiles) throws ClickHouseException {
        ClickHouseRequest<?> request = this.getProxy().getClickhouseConnection(shard);
        for (String clickhouseLocalFile : clickhouseLocalFiles) {
            String attachSql = String.format("ALTER TABLE %s ATTACH PART '%s'", this.clickhouseTable.getLocalTableName(), clickhouseLocalFile.substring(clickhouseLocalFile.lastIndexOf("/") + 1));
            log.info("Attach file to clickhouse table: {}", (Object)attachSql);
            ClickHouseResponse response = ((ClickHouseRequest)request.query(attachSql)).executeAndWait();
            response.close();
        }
    }
}

