/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.FileTransfer;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsyncFileTransfer
implements FileTransfer {
    private static final Logger log = LoggerFactory.getLogger(RsyncFileTransfer.class);
    private static final int SSH_PORT = 22;
    private final String host;
    private final String user;
    private final String password;
    private final String keyPath;
    private ClientSession clientSession;
    private SshClient sshClient;

    public RsyncFileTransfer(String host, String user, String password, String keyPath) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.keyPath = keyPath;
    }

    @Override
    public void init() {
        try {
            this.sshClient = SshClient.setUpDefaultClient();
            this.sshClient.start();
            this.clientSession = (ClientSession)((ConnectFuture)this.sshClient.connect(this.user, this.host, 22).verify()).getSession();
            if (this.password != null) {
                this.clientSession.addPasswordIdentity(this.password);
            }
            if (this.keyPath != null) {
                FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(Paths.get(this.keyPath, new String[0]));
                KeyPair fileKeyPair = fileKeyPairProvider.loadKey(this.clientSession, "ssh-rsa");
                this.clientSession.addPublicKeyIdentity(fileKeyPair);
            }
            if (!((AuthFuture)this.clientSession.auth().verify()).isSuccess()) {
                throw new ClickhouseConnectorException((SeaTunnelErrorCode)ClickhouseConnectorErrorCode.SSH_OPERATION_FAILED, "ssh host " + this.host + "authentication failed");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ClickhouseConnectorException(ClickhouseConnectorErrorCode.SSH_OPERATION_FAILED, "Failed to connect to host: " + this.host + " by user: " + this.user + " on port 22", e);
        }
    }

    @Override
    public void transferAndChown(String sourcePath, String targetPath) {
        try {
            String line2;
            Throwable throwable;
            BufferedReader bufferedReader2;
            Throwable throwable2;
            String sshParameter = this.password != null ? String.format("'sshpass -p %s ssh -o StrictHostKeyChecking=no -p %s'", this.password, 22) : (this.keyPath != null ? String.format("'ssh -i %s -o StrictHostKeyChecking=no -p %s'", this.keyPath, 22) : String.format("'ssh -o StrictHostKeyChecking=no -p %s'", 22));
            ArrayList<String> rsyncCommand = new ArrayList<String>();
            rsyncCommand.add("rsync");
            rsyncCommand.add("-r");
            rsyncCommand.add("-z");
            rsyncCommand.add("-v");
            rsyncCommand.add("-e");
            rsyncCommand.add(sshParameter);
            rsyncCommand.add(sourcePath);
            rsyncCommand.add(String.format("%s@%s:%s", this.user, this.host, targetPath));
            log.info("Generate rsync command: {}", (Object)String.join((CharSequence)" ", rsyncCommand));
            ProcessBuilder processBuilder = new ProcessBuilder("bash", "-c", String.join((CharSequence)" ", rsyncCommand));
            Process start = processBuilder.start();
            try (InputStream inputStream = start.getInputStream();){
                throwable2 = null;
                try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                    bufferedReader2 = new BufferedReader(inputStreamReader);
                    throwable = null;
                    try {
                        while ((line2 = bufferedReader2.readLine()) != null) {
                            log.info("rsync output: {}", (Object)line2);
                        }
                    }
                    catch (Throwable line2) {
                        throwable = line2;
                        throw line2;
                    }
                    finally {
                        if (bufferedReader2 != null) {
                            if (throwable != null) {
                                try {
                                    bufferedReader2.close();
                                }
                                catch (Throwable line2) {
                                    throwable.addSuppressed(line2);
                                }
                            } else {
                                bufferedReader2.close();
                            }
                        }
                    }
                }
                catch (Throwable bufferedReader2) {
                    throwable2 = bufferedReader2;
                    throw bufferedReader2;
                }
            }
            var8_10 = null;
            try (InputStream errorStream = start.getErrorStream();){
                throwable2 = null;
                try (InputStreamReader errorStreamReader = new InputStreamReader(errorStream);){
                    bufferedReader2 = new BufferedReader(errorStreamReader);
                    throwable = null;
                    try {
                        while ((line2 = bufferedReader2.readLine()) != null) {
                            log.error("rsync error: {}", (Object)line2);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bufferedReader2 != null) {
                            if (throwable != null) {
                                try {
                                    bufferedReader2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                bufferedReader2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
            }
            catch (Throwable throwable6) {
                var8_10 = throwable6;
                throw throwable6;
            }
            start.waitFor();
        }
        catch (IOException | InterruptedException ex) {
            throw CommonError.fileOperationFailed((String)"ClickhouseFile", (String)"transfer", (String)(sourcePath + " -> " + targetPath), (Throwable)ex);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("ls");
        command.add("-l");
        command.add(targetPath.substring(0, StringUtils.stripEnd(targetPath, "/").lastIndexOf("/")) + "/");
        command.add("| tail -n 1 | awk '{print $3}' | xargs -t -i chown -R {}:{} " + targetPath);
        try {
            String finalCommand = String.join((CharSequence)" ", command);
            log.info("execute remote command: " + finalCommand);
            this.clientSession.executeRemoteCommand(finalCommand);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void transferAndChown(List<String> sourcePaths, String targetPath) {
        if (sourcePaths == null) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "sourcePath is null");
        }
        sourcePaths.forEach(sourcePath -> this.transferAndChown((String)sourcePath, targetPath));
    }

    @Override
    public void close() {
        if (this.clientSession != null && this.clientSession.isOpen()) {
            try {
                this.clientSession.close();
            }
            catch (IOException e) {
                throw new ClickhouseConnectorException(ClickhouseConnectorErrorCode.SSH_OPERATION_FAILED, "Failed to close ssh session", e);
            }
        }
        if (this.sshClient != null && this.sshClient.isOpen()) {
            this.sshClient.stop();
            try {
                this.sshClient.close();
            }
            catch (IOException e) {
                throw new ClickhouseConnectorException(ClickhouseConnectorErrorCode.SSH_OPERATION_FAILED, "Failed to close ssh client", e);
            }
        }
    }
}

