/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.ClickhouseFieldInjectFunction;

public class ArrayInjectFunction
implements ClickhouseFieldInjectFunction {
    private static final Pattern PATTERN = Pattern.compile("(Array.*)");
    private String fieldType;

    @Override
    public void injectFields(PreparedStatement statement, int index, Object value) throws SQLException {
        String sqlType;
        String type;
        Object[] elements = (Object[])value;
        switch (type = this.fieldType.substring(this.fieldType.indexOf("(") + 1, this.fieldType.indexOf(")"))) {
            case "String": 
            case "Int128": 
            case "UInt128": 
            case "Int256": 
            case "UInt256": {
                sqlType = "TEXT";
                elements = Arrays.copyOf(elements, elements.length, String[].class);
                break;
            }
            case "Int8": {
                sqlType = "TINYINT";
                elements = Arrays.copyOf(elements, elements.length, Byte[].class);
                break;
            }
            case "UInt8": 
            case "Int16": {
                sqlType = "SMALLINT";
                elements = Arrays.copyOf(elements, elements.length, Short[].class);
                break;
            }
            case "UInt16": 
            case "Int32": {
                sqlType = "INTEGER";
                elements = Arrays.copyOf(elements, elements.length, Integer[].class);
                break;
            }
            case "UInt32": 
            case "Int64": 
            case "UInt64": {
                sqlType = "BIGINT";
                elements = Arrays.copyOf(elements, elements.length, Long[].class);
                break;
            }
            case "Float32": {
                sqlType = "REAL";
                elements = Arrays.copyOf(elements, elements.length, Float[].class);
                break;
            }
            case "Float64": {
                sqlType = "DOUBLE";
                elements = Arrays.copyOf(elements, elements.length, Double[].class);
                break;
            }
            case "Bool": {
                sqlType = "BOOLEAN";
                elements = Arrays.copyOf(elements, elements.length, Boolean[].class);
                break;
            }
            default: {
                throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "array inject error, unsupported data type: " + type);
            }
        }
        statement.setArray(index, statement.getConnection().createArrayOf(sqlType, elements));
    }

    @Override
    public boolean isCurrentFieldType(String fieldType) {
        if (PATTERN.matcher(fieldType).matches()) {
            this.fieldType = fieldType;
            return true;
        }
        return false;
    }
}

