/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.source;

import com.clickhouse.client.ClickHouseNode;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhouseSourceReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;

public class ClickhouseSource
extends AbstractSingleSplitSource<SeaTunnelRow> {
    private final List<ClickHouseNode> servers;
    private final CatalogTable catalogTable;
    private final String sql;
    private final SeaTunnelRowType rowTypeInfo;

    public ClickhouseSource(List<ClickHouseNode> servers, CatalogTable catalogTable, String sql) {
        this.servers = servers;
        this.catalogTable = catalogTable;
        this.sql = sql;
        this.rowTypeInfo = catalogTable.getSeaTunnelRowType();
    }

    public String getPluginName() {
        return "Clickhouse";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) {
        return new ClickhouseSourceReader(this.servers, readerContext, this.sql, this.rowTypeInfo);
    }
}

