/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.util;

import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseBaseOptions;

public class ClickhouseUtil {
    public static List<ClickHouseNode> createNodes(ReadonlyConfig config) {
        return ClickhouseUtil.createNodes((String)config.get(ClickhouseBaseOptions.HOST), (String)config.get(ClickhouseBaseOptions.DATABASE), (String)config.get(ClickhouseBaseOptions.SERVER_TIME_ZONE), (String)config.get(ClickhouseBaseOptions.USERNAME), (String)config.get(ClickhouseBaseOptions.PASSWORD), (Map)config.get(ClickhouseBaseOptions.CLICKHOUSE_CONFIG));
    }

    public static List<ClickHouseNode> createNodes(String nodeAddress, String database, String serverTimeZone, String username, String password, Map<String, String> options) {
        return Arrays.stream(nodeAddress.split(",")).map(address -> {
            String[] nodeAndPort = address.split(":", 2);
            ClickHouseNode.Builder builder = ClickHouseNode.builder().host(nodeAndPort[0]).port(ClickHouseProtocol.HTTP, Integer.parseInt(nodeAndPort[1])).database(database).timeZone(serverTimeZone);
            if (MapUtils.isNotEmpty((Map)options)) {
                for (Map.Entry entry : options.entrySet()) {
                    builder = builder.addOption((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
                builder = builder.credentials(ClickHouseCredentials.fromUserAndPassword(username, password));
            }
            return builder.build();
        }).collect(Collectors.toList());
    }
}

