/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.JdbcBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.StatementFactory;

public class InsertOrUpdateBatchStatementExecutor
implements JdbcBatchStatementExecutor {
    private final StatementFactory existStmtFactory;
    @NonNull
    private final StatementFactory insertStmtFactory;
    @NonNull
    private final StatementFactory updateStmtFactory;
    private final Function<SeaTunnelRow, SeaTunnelRow> keyExtractor;
    private final JdbcRowConverter keyRowConverter;
    @NonNull
    private final JdbcRowConverter valueRowConverter;
    private transient PreparedStatement existStatement;
    private transient PreparedStatement insertStatement;
    private transient PreparedStatement updateStatement;
    private transient Boolean preChangeFlag;
    private transient boolean submitted;

    public InsertOrUpdateBatchStatementExecutor(StatementFactory insertStmtFactory, StatementFactory updateStmtFactory, JdbcRowConverter rowConverter) {
        this(null, insertStmtFactory, updateStmtFactory, null, null, rowConverter);
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        if (this.upsertMode()) {
            this.existStatement = this.existStmtFactory.createStatement(connection);
        }
        this.insertStatement = this.insertStmtFactory.createStatement(connection);
        this.updateStatement = this.updateStmtFactory.createStatement(connection);
    }

    private boolean upsertMode() {
        return this.existStmtFactory != null;
    }

    private boolean hasInsert(SeaTunnelRow record) throws SQLException {
        if (this.upsertMode()) {
            return !this.exist(this.keyExtractor.apply(record));
        }
        switch (record.getRowKind()) {
            case INSERT: {
                return true;
            }
            case UPDATE_AFTER: {
                return false;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToBatch(SeaTunnelRow record) throws SQLException {
        boolean currentChangeFlag = this.hasInsert(record);
        if (currentChangeFlag) {
            if (this.preChangeFlag != null && !this.preChangeFlag.booleanValue()) {
                this.updateStatement.executeBatch();
                this.updateStatement.clearBatch();
            }
            this.valueRowConverter.toExternal(record, this.insertStatement);
            this.insertStatement.addBatch();
        } else {
            if (this.preChangeFlag != null && this.preChangeFlag.booleanValue()) {
                this.insertStatement.executeBatch();
                this.insertStatement.clearBatch();
            }
            this.valueRowConverter.toExternal(record, this.updateStatement);
            this.updateStatement.addBatch();
        }
        this.preChangeFlag = currentChangeFlag;
        this.submitted = false;
    }

    @Override
    public void executeBatch() throws SQLException {
        if (this.preChangeFlag != null) {
            if (this.preChangeFlag.booleanValue()) {
                this.insertStatement.executeBatch();
                this.insertStatement.clearBatch();
            } else {
                this.updateStatement.executeBatch();
                this.updateStatement.clearBatch();
            }
        }
        this.submitted = true;
    }

    @Override
    public void closeStatements() throws SQLException {
        if (!this.submitted) {
            this.executeBatch();
        }
        for (PreparedStatement statement : Arrays.asList(this.existStatement, this.insertStatement, this.updateStatement)) {
            if (statement == null) continue;
            statement.close();
        }
    }

    private boolean exist(SeaTunnelRow pk) throws SQLException {
        this.keyRowConverter.toExternal(pk, this.existStatement);
        try (ResultSet resultSet = this.existStatement.executeQuery();){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    public InsertOrUpdateBatchStatementExecutor(StatementFactory existStmtFactory, @NonNull StatementFactory insertStmtFactory, @NonNull StatementFactory updateStmtFactory, Function<SeaTunnelRow, SeaTunnelRow> keyExtractor, JdbcRowConverter keyRowConverter, @NonNull JdbcRowConverter valueRowConverter) {
        if (insertStmtFactory == null) {
            throw new NullPointerException("insertStmtFactory is marked non-null but is null");
        }
        if (updateStmtFactory == null) {
            throw new NullPointerException("updateStmtFactory is marked non-null but is null");
        }
        if (valueRowConverter == null) {
            throw new NullPointerException("valueRowConverter is marked non-null but is null");
        }
        this.existStmtFactory = existStmtFactory;
        this.insertStmtFactory = insertStmtFactory;
        this.updateStmtFactory = updateStmtFactory;
        this.keyExtractor = keyExtractor;
        this.keyRowConverter = keyRowConverter;
        this.valueRowConverter = valueRowConverter;
    }
}

