/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file;

import com.clickhouse.client.ClickHouseNode;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseConfig;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseFileCopyMethod;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.FileReaderOption;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.Shard;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.ShardMetadata;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.ClickhouseProxy;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.ClickhouseFileSinkAggCommitter;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.ClickhouseFileSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.ClickhouseTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.CKFileAggCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.CKFileCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.ClickhouseSinkState;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseUtil;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigMergeable;

@AutoService(value={SeaTunnelSink.class})
public class ClickhouseFileSink
implements SeaTunnelSink<SeaTunnelRow, ClickhouseSinkState, CKFileCommitInfo, CKFileAggCommitInfo> {
    private FileReaderOption readerOption;

    public String getPluginName() {
        return "ClickhouseFile";
    }

    public void prepare(Config config) throws PrepareFailException {
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{ClickhouseConfig.HOST.key(), ClickhouseConfig.TABLE.key(), ClickhouseConfig.DATABASE.key(), ClickhouseConfig.USERNAME.key(), ClickhouseConfig.PASSWORD.key(), ClickhouseConfig.CLICKHOUSE_LOCAL_PATH.key()});
        if (!checkResult.isSuccess()) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SINK, checkResult.getMsg()));
        }
        ImmutableMap defaultConfigs = ImmutableMap.builder().put((Object)ClickhouseConfig.COPY_METHOD.key(), (Object)((ClickhouseFileCopyMethod)((Object)ClickhouseConfig.COPY_METHOD.defaultValue())).getName()).put((Object)ClickhouseConfig.NODE_FREE_PASSWORD.key(), ClickhouseConfig.NODE_FREE_PASSWORD.defaultValue()).put((Object)ClickhouseConfig.COMPATIBLE_MODE.key(), ClickhouseConfig.COMPATIBLE_MODE.defaultValue()).put((Object)ClickhouseConfig.FILE_TEMP_PATH.key(), ClickhouseConfig.FILE_TEMP_PATH.defaultValue()).put((Object)ClickhouseConfig.FILE_FIELDS_DELIMITER.key(), ClickhouseConfig.FILE_FIELDS_DELIMITER.defaultValue()).build();
        config = config.withFallback((ConfigMergeable)ConfigFactory.parseMap((Map)defaultConfigs));
        List<ClickHouseNode> nodes = ClickhouseUtil.createNodes(config.getString(ClickhouseConfig.HOST.key()), config.getString(ClickhouseConfig.DATABASE.key()), config.getString(ClickhouseConfig.SERVER_TIME_ZONE.key()), config.getString(ClickhouseConfig.USERNAME.key()), config.getString(ClickhouseConfig.PASSWORD.key()));
        ClickhouseProxy proxy = new ClickhouseProxy(nodes.get(0));
        Map<String, String> tableSchema = proxy.getClickhouseTableSchema(config.getString(ClickhouseConfig.TABLE.key()));
        ClickhouseTable table = proxy.getClickhouseTable(config.getString(ClickhouseConfig.DATABASE.key()), config.getString(ClickhouseConfig.TABLE.key()));
        String shardKey = null;
        String shardKeyType = null;
        if (config.hasPath(ClickhouseConfig.SHARDING_KEY.key())) {
            shardKey = config.getString(ClickhouseConfig.SHARDING_KEY.key());
            shardKeyType = tableSchema.get(shardKey);
        }
        ShardMetadata shardMetadata = new ShardMetadata(shardKey, shardKeyType, config.getString(ClickhouseConfig.DATABASE.key()), config.getString(ClickhouseConfig.TABLE.key()), table.getEngine(), true, new Shard(1, 1, nodes.get(0)), config.getString(ClickhouseConfig.USERNAME.key()), config.getString(ClickhouseConfig.PASSWORD.key()));
        ArrayList<String> fields = new ArrayList<String>(tableSchema.keySet());
        Map<String, String> nodeUser = config.getObjectList(ClickhouseConfig.NODE_PASS.key()).stream().collect(Collectors.toMap(configObject -> configObject.toConfig().getString("node_address"), configObject -> configObject.toConfig().hasPath(ClickhouseConfig.USERNAME.key()) ? configObject.toConfig().getString(ClickhouseConfig.USERNAME.key()) : "root"));
        Map<String, String> nodePassword = config.getObjectList(ClickhouseConfig.NODE_PASS.key()).stream().collect(Collectors.toMap(configObject -> configObject.toConfig().getString("node_address"), configObject -> configObject.toConfig().getString(ClickhouseConfig.PASSWORD.key())));
        proxy.close();
        if (config.getString(ClickhouseConfig.FILE_FIELDS_DELIMITER.key()).length() != 1) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, ClickhouseConfig.FILE_FIELDS_DELIMITER.key() + " must be a single character");
        }
        this.readerOption = new FileReaderOption(shardMetadata, tableSchema, fields, config.getString(ClickhouseConfig.CLICKHOUSE_LOCAL_PATH.key()), ClickhouseFileCopyMethod.from(config.getString(ClickhouseConfig.COPY_METHOD.key())), nodeUser, config.getBoolean(ClickhouseConfig.NODE_FREE_PASSWORD.key()), nodePassword, config.getBoolean(ClickhouseConfig.COMPATIBLE_MODE.key()), config.getString(ClickhouseConfig.FILE_TEMP_PATH.key()), config.getString(ClickhouseConfig.FILE_FIELDS_DELIMITER.key()));
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.readerOption.setSeaTunnelRowType(seaTunnelRowType);
    }

    public SinkWriter<SeaTunnelRow, CKFileCommitInfo, ClickhouseSinkState> createWriter(SinkWriter.Context context) throws IOException {
        return new ClickhouseFileSinkWriter(this.readerOption, context);
    }

    public Optional<Serializer<CKFileCommitInfo>> getCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<SinkAggregatedCommitter<CKFileCommitInfo, CKFileAggCommitInfo>> createAggregatedCommitter() throws IOException {
        return Optional.of(new ClickhouseFileSinkAggCommitter(this.readerOption));
    }

    public Optional<Serializer<CKFileAggCommitInfo>> getAggregatedCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }
}

