/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client;

import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ReaderOption;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.Shard;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.ClickhouseBatchStatement;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.ClickhouseProxy;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.ShardRouter;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.JdbcBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.JdbcBatchStatementExecutorBuilder;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.CKCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.ClickhouseSinkState;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.tool.IntHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickhouseSinkWriter
implements SinkWriter<SeaTunnelRow, CKCommitInfo, ClickhouseSinkState> {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseSinkWriter.class);
    private final SinkWriter.Context context;
    private final ReaderOption option;
    private final ShardRouter shardRouter;
    private final transient ClickhouseProxy proxy;
    private final Map<Shard, ClickhouseBatchStatement> statementMap;

    ClickhouseSinkWriter(ReaderOption option, SinkWriter.Context context) {
        this.option = option;
        this.context = context;
        this.proxy = new ClickhouseProxy(option.getShardMetadata().getDefaultShard().getNode());
        this.shardRouter = new ShardRouter(this.proxy, option.getShardMetadata());
        this.statementMap = this.initStatementMap();
    }

    public void write(SeaTunnelRow element) throws IOException {
        Object shardKey = null;
        if (StringUtils.isNotEmpty(this.option.getShardMetadata().getShardKey())) {
            int i = this.option.getSeaTunnelRowType().indexOf(this.option.getShardMetadata().getShardKey());
            shardKey = element.getField(i);
        }
        ClickhouseBatchStatement statement = this.statementMap.get(this.shardRouter.getShard(shardKey));
        JdbcBatchStatementExecutor clickHouseStatement = statement.getJdbcBatchStatementExecutor();
        IntHolder sizeHolder = statement.getIntHolder();
        this.addIntoBatch(element, clickHouseStatement);
        sizeHolder.setValue(sizeHolder.getValue() + 1);
        if (sizeHolder.getValue() >= this.option.getBulkSize()) {
            this.flush(clickHouseStatement);
            sizeHolder.setValue(0);
        }
    }

    public Optional<CKCommitInfo> prepareCommit() throws IOException {
        for (ClickhouseBatchStatement batchStatement : this.statementMap.values()) {
            JdbcBatchStatementExecutor statement = batchStatement.getJdbcBatchStatementExecutor();
            IntHolder intHolder = batchStatement.getIntHolder();
            if (intHolder.getValue() <= 0) continue;
            this.flush(statement);
            intHolder.setValue(0);
        }
        return Optional.empty();
    }

    public void abortPrepare() {
    }

    public void close() throws IOException {
        this.proxy.close();
        this.flush();
    }

    private void addIntoBatch(SeaTunnelRow row, JdbcBatchStatementExecutor clickHouseStatement) {
        try {
            clickHouseStatement.addToBatch(row);
        }
        catch (SQLException e) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.SQL_OPERATION_FAILED, "Add row data into batch error", e);
        }
    }

    private void flush(JdbcBatchStatementExecutor clickHouseStatement) {
        try {
            clickHouseStatement.executeBatch();
        }
        catch (Exception e) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.FLUSH_DATA_FAILED, "Clickhouse execute batch statement error", e);
        }
    }

    private void flush() {
        for (ClickhouseBatchStatement batchStatement : this.statementMap.values()) {
            try {
                ClickHouseConnectionImpl needClosedConnection = batchStatement.getClickHouseConnection();
                Throwable throwable = null;
                try {
                    JdbcBatchStatementExecutor needClosedStatement = batchStatement.getJdbcBatchStatementExecutor();
                    Throwable throwable2 = null;
                    try {
                        IntHolder intHolder = batchStatement.getIntHolder();
                        if (intHolder.getValue() <= 0) continue;
                        this.flush(needClosedStatement);
                        intHolder.setValue(0);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (needClosedStatement == null) continue;
                        if (throwable2 != null) {
                            try {
                                needClosedStatement.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        needClosedStatement.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (needClosedConnection == null) continue;
                    if (throwable != null) {
                        try {
                            needClosedConnection.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    needClosedConnection.close();
                }
            }
            catch (SQLException e) {
                throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.SQL_OPERATION_FAILED, "Failed to close prepared statement.", e);
            }
        }
    }

    private Map<Shard, ClickhouseBatchStatement> initStatementMap() {
        HashMap<Shard, ClickhouseBatchStatement> result = new HashMap<Shard, ClickhouseBatchStatement>(16);
        this.shardRouter.getShards().forEach((weight, s) -> {
            try {
                ClickHouseConnectionImpl clickhouseConnection = new ClickHouseConnectionImpl(s.getJdbcUrl(), this.option.getProperties());
                String[] orderByKeys = null;
                if (!Strings.isNullOrEmpty((String)this.shardRouter.getSortingKey())) {
                    orderByKeys = (String[])Stream.of(this.shardRouter.getSortingKey().split(",")).map(key -> StringUtils.trim(key)).toArray(String[]::new);
                }
                JdbcBatchStatementExecutor jdbcBatchStatementExecutor = new JdbcBatchStatementExecutorBuilder().setTable(this.shardRouter.getShardTable()).setTableEngine(this.shardRouter.getShardTableEngine()).setRowType(this.option.getSeaTunnelRowType()).setPrimaryKeys(this.option.getPrimaryKeys()).setOrderByKeys(orderByKeys).setClickhouseTableSchema(this.option.getTableSchema()).setAllowExperimentalLightweightDelete(this.option.isAllowExperimentalLightweightDelete()).setClickhouseServerEnableExperimentalLightweightDelete(this.clickhouseServerEnableExperimentalLightweightDelete(clickhouseConnection)).setSupportUpsert(this.option.isSupportUpsert()).build();
                jdbcBatchStatementExecutor.prepareStatements(clickhouseConnection);
                IntHolder intHolder = new IntHolder();
                ClickhouseBatchStatement batchStatement = new ClickhouseBatchStatement(clickhouseConnection, jdbcBatchStatementExecutor, intHolder);
                result.put((Shard)s, batchStatement);
            }
            catch (SQLException e) {
                throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.SQL_OPERATION_FAILED, "Clickhouse prepare statement error: " + e.getMessage(), e);
            }
        });
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean clickhouseServerEnableExperimentalLightweightDelete(ClickHouseConnectionImpl clickhouseConnection) {
        if (!this.option.isAllowExperimentalLightweightDelete()) {
            return false;
        }
        String configKey = "allow_experimental_lightweight_delete";
        try (ClickHouseStatement stmt = clickhouseConnection.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SHOW SETTINGS ILIKE '%" + configKey + "%'");
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if (!name.equalsIgnoreCase(configKey)) continue;
                boolean bl = resultSet.getBoolean("value");
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            log.warn("Failed to get clickhouse server config: {}", (Object)configKey, (Object)e);
            return false;
        }
    }
}

