/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.inject.ClickhouseFieldInjectFunction;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class StringInjectFunction
implements ClickhouseFieldInjectFunction {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String fieldType;

    @Override
    public void injectFields(PreparedStatement statement, int index, Object value) throws SQLException {
        try {
            if ("Point".equals(this.fieldType)) {
                statement.setObject(index, MAPPER.readValue(StringInjectFunction.replace(value.toString()), double[].class));
            } else if ("Ring".equals(this.fieldType)) {
                statement.setObject(index, MAPPER.readValue(StringInjectFunction.replace(value.toString()), double[][].class));
            } else if ("Polygon".equals(this.fieldType)) {
                statement.setObject(index, MAPPER.readValue(StringInjectFunction.replace(value.toString()), double[][][].class));
            } else if ("MultiPolygon".equals(this.fieldType)) {
                statement.setObject(index, MAPPER.readValue(StringInjectFunction.replace(value.toString()), double[][][][].class));
            } else {
                statement.setString(index, value.toString());
            }
        }
        catch (JsonProcessingException e) {
            throw CommonError.jsonOperationError((String)"Clickhouse", (String)value.toString(), (Throwable)e);
        }
    }

    @Override
    public boolean isCurrentFieldType(String fieldType) {
        if ("String".equals(fieldType) || "Int128".equals(fieldType) || "UInt128".equals(fieldType) || "Int256".equals(fieldType) || "UInt256".equals(fieldType) || "Point".equals(fieldType) || "Ring".equals(fieldType) || "Polygon".equals(fieldType) || "MultiPolygon".equals(fieldType)) {
            this.fieldType = fieldType;
            return true;
        }
        return false;
    }

    private static String replace(String str) {
        return str.replaceAll("\\(", "[").replaceAll("\\)", "]");
    }
}

