/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client;

import com.clickhouse.client.ClickHouseRequest;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.Shard;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.ShardMetadata;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.DistributedEngine;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.ClickhouseProxy;

public class ShardRouter
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String shardTable;
    private String shardTableEngine;
    private final String table;
    private final String tableEngine;
    private int shardWeightCount;
    private final TreeMap<Integer, Shard> shards;
    private final String shardKey;
    private final String shardKeyType;
    private final String sortingKey;
    private final boolean splitMode;
    private static final XXHash64 HASH_INSTANCE = XXHashFactory.fastestInstance().hash64();
    private final ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();

    public ShardRouter(ClickhouseProxy proxy, ShardMetadata shardMetadata) {
        this.shards = new TreeMap();
        this.shardKey = shardMetadata.getShardKey();
        this.shardKeyType = shardMetadata.getShardKeyType();
        this.sortingKey = shardMetadata.getSortingKey();
        this.splitMode = shardMetadata.isSplitMode();
        this.table = shardMetadata.getTable();
        this.tableEngine = shardMetadata.getTableEngine();
        if (StringUtils.isNotEmpty(this.shardKey) && StringUtils.isEmpty(this.shardKeyType)) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)ClickhouseConnectorErrorCode.SHARD_KEY_NOT_FOUND, "Shard key " + this.shardKey + " not found in table " + this.table);
        }
        ClickHouseRequest<?> connection = proxy.getClickhouseConnection();
        if (this.splitMode) {
            DistributedEngine localTable = proxy.getClickhouseDistributedTable(connection, shardMetadata.getDatabase(), this.table);
            this.shardTable = localTable.getTable();
            this.shardTableEngine = localTable.getTableEngine();
            List<Shard> shardList = proxy.getClusterShardList(connection, localTable.getClusterName(), localTable.getDatabase(), shardMetadata.getDefaultShard().getNode().getPort(), shardMetadata.getUsername(), shardMetadata.getPassword());
            int weight = 0;
            for (Shard shard : shardList) {
                this.shards.put(weight, shard);
                weight += shard.getNode().getWeight();
            }
            this.shardWeightCount = weight;
        } else {
            this.shards.put(0, shardMetadata.getDefaultShard());
        }
    }

    public String getShardTable() {
        return this.splitMode ? this.shardTable : this.table;
    }

    public String getShardTableEngine() {
        return this.splitMode ? this.shardTableEngine : this.tableEngine;
    }

    public Shard getShard(Object shardValue) {
        if (!this.splitMode) {
            return this.shards.firstEntry().getValue();
        }
        if (StringUtils.isEmpty(this.shardKey) || shardValue == null) {
            return this.shards.lowerEntry(this.threadLocalRandom.nextInt(this.shardWeightCount) + 1).getValue();
        }
        int offset = (int)(HASH_INSTANCE.hash(ByteBuffer.wrap(shardValue.toString().getBytes(StandardCharsets.UTF_8)), 0L) & Long.MAX_VALUE % (long)this.shardWeightCount);
        return this.shards.lowerEntry(offset + 1).getValue();
    }

    public TreeMap<Integer, Shard> getShards() {
        return this.shards;
    }

    public String getSortingKey() {
        return this.sortingKey;
    }
}

