/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.FileTransfer;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.client.ScpClientCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpFileTransfer
implements FileTransfer {
    private static final Logger log = LoggerFactory.getLogger(ScpFileTransfer.class);
    private static final int SCP_PORT = 22;
    private final String host;
    private final String user;
    private final String password;
    private ScpClient scpClient;
    private ClientSession clientSession;
    private SshClient sshClient;

    public ScpFileTransfer(String host, String user, String password) {
        this.host = host;
        this.user = user;
        this.password = password;
    }

    @Override
    public void init() {
        try {
            this.sshClient = SshClient.setUpDefaultClient();
            this.sshClient.start();
            this.clientSession = (ClientSession)((ConnectFuture)this.sshClient.connect(this.user, this.host, 22).verify()).getSession();
            if (this.password != null) {
                this.clientSession.addPasswordIdentity(this.password);
            }
            if (!((AuthFuture)this.clientSession.auth().verify()).isSuccess()) {
                throw new ClickhouseConnectorException((SeaTunnelErrorCode)ClickhouseConnectorErrorCode.SSH_OPERATION_FAILED, "ssh host " + this.host + "authentication failed");
            }
            this.scpClient = ScpClientCreator.instance().createScpClient(this.clientSession);
        }
        catch (IOException e) {
            throw new ClickhouseConnectorException(ClickhouseConnectorErrorCode.SSH_OPERATION_FAILED, "Failed to connect to host: " + this.host + " by user: " + this.user + " on port 22", e);
        }
    }

    @Override
    public void transferAndChown(String sourcePath, String targetPath) {
        try {
            this.scpClient.upload(sourcePath, targetPath, ScpClient.Option.Recursive, ScpClient.Option.TargetIsDirectory, ScpClient.Option.PreserveAttributes);
        }
        catch (IOException e) {
            throw CommonError.fileOperationFailed((String)"ClickhouseFile", (String)"transfer", (String)(sourcePath + " -> " + targetPath), (Throwable)e);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("ls");
        command.add("-l");
        command.add(targetPath.substring(0, StringUtils.stripEnd(targetPath, "/").lastIndexOf("/")) + "/");
        command.add("| tail -n 1 | awk '{print $3}' | xargs -t -i chown -R {}:{} " + targetPath);
        try {
            String finalCommand = String.join((CharSequence)" ", command);
            log.info("execute remote command: " + finalCommand);
            this.clientSession.executeRemoteCommand(finalCommand);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void transferAndChown(List<String> sourcePaths, String targetPath) {
        if (sourcePaths == null) {
            throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "sourcePath is null");
        }
        sourcePaths.forEach(sourcePath -> this.transferAndChown((String)sourcePath, targetPath));
    }

    @Override
    public void close() {
        if (this.clientSession != null && this.clientSession.isOpen()) {
            try {
                this.clientSession.close();
            }
            catch (IOException e) {
                throw new ClickhouseConnectorException(ClickhouseConnectorErrorCode.SSH_OPERATION_FAILED, "Failed to close ssh session", e);
            }
        }
        if (this.sshClient != null && this.sshClient.isOpen()) {
            this.sshClient.stop();
            try {
                this.sshClient.close();
            }
            catch (IOException e) {
                throw new ClickhouseConnectorException(ClickhouseConnectorErrorCode.SSH_OPERATION_FAILED, "Failed to close ssh client", e);
            }
        }
    }
}

