/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.JdbcBatchStatementExecutor;

public class ReduceBufferedBatchStatementExecutor
implements JdbcBatchStatementExecutor {
    @NonNull
    private final JdbcBatchStatementExecutor insertOrUpdateExecutor;
    @NonNull
    private final JdbcBatchStatementExecutor deleteExecutor;
    @NonNull
    private final Function<SeaTunnelRow, SeaTunnelRow> keyExtractor;
    @NonNull
    private final Function<SeaTunnelRow, SeaTunnelRow> valueTransform;
    private boolean ignoreUpdateBefore;
    @NonNull
    private final LinkedHashMap<SeaTunnelRow, Pair<Boolean, SeaTunnelRow>> buffer = new LinkedHashMap();

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.insertOrUpdateExecutor.prepareStatements(connection);
        this.deleteExecutor.prepareStatements(connection);
    }

    @Override
    public void addToBatch(SeaTunnelRow record) throws SQLException {
        if (RowKind.UPDATE_BEFORE.equals((Object)record.getRowKind()) && this.ignoreUpdateBefore) {
            return;
        }
        SeaTunnelRow key = this.keyExtractor.apply(record);
        boolean changeFlag = this.changeFlag(record.getRowKind());
        SeaTunnelRow value = this.valueTransform.apply(record);
        this.buffer.put(key, Pair.of(changeFlag, value));
    }

    @Override
    public void executeBatch() throws SQLException {
        Boolean preChangeFlag = null;
        Set<Map.Entry<SeaTunnelRow, Pair<Boolean, SeaTunnelRow>>> entrySet = this.buffer.entrySet();
        for (Map.Entry<SeaTunnelRow, Pair<Boolean, SeaTunnelRow>> entry : entrySet) {
            Boolean currentChangeFlag = entry.getValue().getKey();
            if (currentChangeFlag.booleanValue()) {
                if (preChangeFlag != null && !preChangeFlag.booleanValue()) {
                    this.deleteExecutor.executeBatch();
                }
                this.insertOrUpdateExecutor.addToBatch(entry.getValue().getValue());
            } else {
                if (preChangeFlag != null && preChangeFlag.booleanValue()) {
                    this.insertOrUpdateExecutor.executeBatch();
                }
                this.deleteExecutor.addToBatch(entry.getKey());
            }
            preChangeFlag = currentChangeFlag;
        }
        if (preChangeFlag != null) {
            if (preChangeFlag.booleanValue()) {
                this.insertOrUpdateExecutor.executeBatch();
            } else {
                this.deleteExecutor.executeBatch();
            }
        }
        this.buffer.clear();
    }

    @Override
    public void closeStatements() throws SQLException {
        if (!this.buffer.isEmpty()) {
            this.executeBatch();
        }
        this.insertOrUpdateExecutor.closeStatements();
        this.deleteExecutor.closeStatements();
    }

    private boolean changeFlag(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                return true;
            }
            case DELETE: 
            case UPDATE_BEFORE: {
                return false;
            }
        }
        throw new UnsupportedOperationException("Unsupported rowKind: " + rowKind);
    }

    public ReduceBufferedBatchStatementExecutor(@NonNull JdbcBatchStatementExecutor insertOrUpdateExecutor, @NonNull JdbcBatchStatementExecutor deleteExecutor, @NonNull Function<SeaTunnelRow, SeaTunnelRow> keyExtractor, @NonNull Function<SeaTunnelRow, SeaTunnelRow> valueTransform, boolean ignoreUpdateBefore) {
        if (insertOrUpdateExecutor == null) {
            throw new NullPointerException("insertOrUpdateExecutor is marked non-null but is null");
        }
        if (deleteExecutor == null) {
            throw new NullPointerException("deleteExecutor is marked non-null but is null");
        }
        if (keyExtractor == null) {
            throw new NullPointerException("keyExtractor is marked non-null but is null");
        }
        if (valueTransform == null) {
            throw new NullPointerException("valueTransform is marked non-null but is null");
        }
        this.insertOrUpdateExecutor = insertOrUpdateExecutor;
        this.deleteExecutor = deleteExecutor;
        this.keyExtractor = keyExtractor;
        this.valueTransform = valueTransform;
        this.ignoreUpdateBefore = ignoreUpdateBefore;
    }

    public ReduceBufferedBatchStatementExecutor(@NonNull JdbcBatchStatementExecutor insertOrUpdateExecutor, @NonNull JdbcBatchStatementExecutor deleteExecutor, @NonNull Function<SeaTunnelRow, SeaTunnelRow> keyExtractor, @NonNull Function<SeaTunnelRow, SeaTunnelRow> valueTransform) {
        if (insertOrUpdateExecutor == null) {
            throw new NullPointerException("insertOrUpdateExecutor is marked non-null but is null");
        }
        if (deleteExecutor == null) {
            throw new NullPointerException("deleteExecutor is marked non-null but is null");
        }
        if (keyExtractor == null) {
            throw new NullPointerException("keyExtractor is marked non-null but is null");
        }
        if (valueTransform == null) {
            throw new NullPointerException("valueTransform is marked non-null but is null");
        }
        this.insertOrUpdateExecutor = insertOrUpdateExecutor;
        this.deleteExecutor = deleteExecutor;
        this.keyExtractor = keyExtractor;
        this.valueTransform = valueTransform;
    }
}

